package com.autotech.we1l.items

import com.autotech.we1l.my_classes.BaseItem
import com.autotech.we1l.tools.*
import org.json.JSONObject
import java.util.*

class Promotion(id: Int, val imageURL: String, val type: Int, private val worth: Int, private val totalInvoice: Int,
                private val publicCode: String, private val startAt: Calendar, private val endAt: Calendar) : BaseItem(id) {

    constructor(promotionJSON: JSONObject) : this(promotionJSON.getInt(ATTR_ID), promotionJSON.getString(ATTR_IMAGE_URL),
            promotionJSON.getInt(ATTR_TYPE), promotionJSON.getInt(ATTR_WORTH), promotionJSON.getInt(ATTR_TOTAL_OF_INVOICE),
            promotionJSON.getString(ATTR_PUBLIC_CODE),
            Calendar.getInstance().apply { timeInMillis = promotionJSON.getLong(ATTR_START_AT) },
            Calendar.getInstance().apply { timeInMillis = promotionJSON.getLong(ATTR_END_AT) })

}