package com.autotech.we1l.my_classes

import android.content.Context
import android.content.ContextWrapper
import android.support.v7.app.AppCompatActivity
import com.android.volley.Request
import com.autotech.we1l.tools.LocaleHelper


abstract class BaseActivity : AppCompatActivity() {

    protected val requestsArray = ArrayList<Request<String>>()

    abstract fun setupViews()
    abstract fun setupClickListeners()
    open fun setupLanguages() {

    }

    override fun attachBaseContext(newBase: Context) {
        super.attachBaseContext(ContextWrapper(LocaleHelper.onAttach(newBase)))
    }

    fun doAll() {
        setupViews()
        setupClickListeners()
        setupLanguages()
    }

    override fun onStop() {
        super.onStop()
        requestsArray.forEachIndexed { _, request ->
            if (!request.isCanceled) request.cancel()
        }
        requestsArray.clear()
    }

    override fun onPause() {
        super.onPause()
        requestsArray.forEachIndexed { _, request ->
            if (!request.isCanceled) request.cancel()
        }
        requestsArray.clear()
    }
}