package com.autotech.we1l.my_classes

import android.os.Bundle
import android.support.v4.app.Fragment
import android.util.Log
import android.view.View
import com.android.volley.Request
import com.autotech.we1l.app.AppLanguage
import com.autotech.we1l.helpers.AnimatorUtils
import com.autotech.we1l.tools.Language.btn_sign_in_or_sign_up
import com.autotech.we1l.tools.Language.dialog_loading
import com.autotech.we1l.tools.Language.prompt_not_logged_in
import com.autotech.we1l.tools.Language.txt_v_no_data
import kotlinx.android.synthetic.main.include_loading_no_data.*
import kotlinx.android.synthetic.main.include_not_logged_in.*

abstract class BaseFragment : Fragment() {

    protected val requestsArray = ArrayList<Request<String>>()

    lateinit var rootView: View

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        doAll()
    }

    open fun setupViews() {

    }

    open fun setupClickListeners() {

    }

    open fun setupLanguages() {
        not_logged_in?.text = AppLanguage.getString(prompt_not_logged_in)
        sign_in_or_sign_up?.text = AppLanguage.getString(btn_sign_in_or_sign_up)

        no_data_text?.text = AppLanguage.getString(txt_v_no_data)
        loading_text?.text = AppLanguage.getString(dialog_loading)
    }

    open fun crucialRequests() {

    }

    private fun doAll() {
        setupViews()
        setupClickListeners()
        setupLanguages()
    }

    fun loading(view: View?) {
        if (view != null) AnimatorUtils.hide(view)
        if (loading_layout != null) {
            Log.i("xxxxxxxxxxxxxx","")
            AnimatorUtils.show(loading_layout)
        }
        if (no_data_layout != null) AnimatorUtils.hide(no_data_layout)
    }

    fun showData(view: View?) {
        if (view != null) AnimatorUtils.show(view)
        if (loading_layout != null) AnimatorUtils.hide(loading_layout)
        if (no_data_layout != null) AnimatorUtils.hide(no_data_layout)
    }

    fun noData(view: View?) {
        if (view != null) AnimatorUtils.hide(view)
        if (loading_layout != null) AnimatorUtils.hide(loading_layout)
        if (no_data_layout != null) AnimatorUtils.show(no_data_layout)
    }

    fun noData(view: View?, content: String) {
        if (view != null) AnimatorUtils.hide(view)
        if (loading_layout != null) AnimatorUtils.hide(loading_layout)
        if (no_data_layout != null) AnimatorUtils.show(no_data_layout)

        no_data_text?.text = content
    }

    override fun onStop() {
        super.onStop()
        requestsArray.forEachIndexed { _, request ->
            if (!request.isCanceled) request.cancel()
        }
        requestsArray.clear()
    }

    override fun onPause() {
        super.onPause()
        requestsArray.forEachIndexed { _, request ->
            if (!request.isCanceled) request.cancel()
        }
        requestsArray.clear()
    }

    override fun onResume() {
        super.onResume()
        crucialRequests()
    }
}