package com.autotech.we1l.my_classes;

import android.support.annotation.NonNull;

import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;

public class BaseList<T extends BaseItem> extends ArrayList<T> {

    public BaseList() {

    }

    @Nullable
    public T findItemById(int id) {
        for (int i = 0; i < size(); i++) {
            if (get(i).getId() == id) {
                return get(i);
            }
        }
        return null;
    }


    public BaseList<T> searchByName(String name) {
        BaseList<T> newList = new BaseList<>();
        for (int i = 0; i < size(); i++) {
            if (get(i).getName().toLowerCase().trim().contains(name.toLowerCase().trim())) {
                newList.add(get(i));
            }
        }
        return newList;
    }


    public ArrayList<String> getNames() {
        ArrayList<String> names = new ArrayList<>();
        for (int i = 0; i < size(); i++) {
            names.add(get(i).getName());
        }
        return names;
    }

    @NonNull
    @Override
    public String toString() {
        StringBuilder toString = new StringBuilder("[");
        for (int i = 0; i < size(); i++) {
            toString.append(get(i).toString());
            if (i != size() - 1) {
                toString.append(",\n");
            }
        }
        toString.append("]\n");
        return toString.toString();
    }
}
