package com.autotech.we1l.my_classes;

import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentStatePagerAdapter;

import java.util.ArrayList;
import java.util.List;

public class BasePagerAdapter extends FragmentStatePagerAdapter {

    private final List<BaseFragment> fragmentList = new ArrayList<>();
    private final List<String> titles = new ArrayList<>();

    public BasePagerAdapter(FragmentManager fm, List<BaseFragment> fragmentList, List<String> titles) {
        super(fm);
        this.fragmentList.addAll(fragmentList);
        this.titles.addAll(titles);
    }

    public BasePagerAdapter(FragmentManager fm, List<BaseFragment> fragmentList) {
        super(fm);
        this.fragmentList.addAll(fragmentList);
    }

    @Override
    public Fragment getItem(int position) {
        return fragmentList.get(position);
    }

    @Override
    public int getCount() {
        return fragmentList.size();
    }

    @Override
    public CharSequence getPageTitle(int position) {
        return titles.get(position);
    }


}
