package com.autotech.we1l.tools;

import android.support.annotation.NonNull;
import android.support.v4.view.ViewPager;
import android.view.View;

public abstract class BaseTransformer implements ViewPager.PageTransformer {

    protected abstract void onTransform(View view, float position);

    @Override
    public void transformPage(@NonNull View view, float position) {
        onPreTransform(view, position);
        onTransform(view, position);
        onPostTransform(view, position);
    }

    protected boolean hideOffscreenPages() {
        return true;
    }

    protected boolean isPagingEnabled() {
        return false;
    }

    protected void onPreTransform(View view, float position) {
        final float width = view.getWidth();

        view.setRotationX(0);
        view.setRotationY(0);
        view.setRotation(0);
        view.setScaleX(1);
        view.setScaleY(1);
        view.setPivotX(0);
        view.setPivotY(0);
        view.setTranslationY(0);
        view.setTranslationX(isPagingEnabled() ? 0f : -width * position);

        if (hideOffscreenPages()) {
            view.setAlpha(position <= -1f || position >= 1f ? 0f : 1f);
        } else {
            view.setAlpha(1f);
        }
    }

    protected void onPostTransform(View view, float position) {
    }

}
