package com.autotech.we1l.tools

import android.os.Environment
import kotlin.contracts.contract

// App:
const val CHANNEL_ID = ""
const val SHARED_PREFERENCES_NAME = "ECommerce"
const val FOLDER_NAME = "/we1l/"
const val SENT_FILES_FOLDER_NAME = "/sent/"
const val SETTINGS_FOLDER_NAME = "/settings/"
var SENT_FILES_FOLDER_PATH = "${Environment.getExternalStorageDirectory()}we1l$SENT_FILES_FOLDER_NAME"
const val PACKAGE_NAME = "com.autotech.we1l"
const val FILE_PROVIDER = "$PACKAGE_NAME.fileprovider"

/* ********************************** */

const val LOCAL_URL = "http://192.168.1.250/ecommerce_mvc/ws/"
const val WEB_URL = "https://we1l.com/ws/"
const val USED_URL = WEB_URL

var isLocal = USED_URL == LOCAL_URL

var REQUEST_LOG_IN = USED_URL + "login"
var REQUEST_SIGN_UP = USED_URL + "signup"
var REQUEST_LOG_OUT = USED_URL + "logout"
var REQUEST_FORGOT_PASSWORD = USED_URL + "forget"
var REQUEST_GET_CATEGORIES = USED_URL + "categories"
var REQUEST_GET_CATEGORY = USED_URL + "category"
var REQUEST_PAYMENT_RESULT = USED_URL + "paymentResult"
var REQUEST_GET_PRODUCT = USED_URL + "product"
var REQUEST_GET_WISH_LIST = USED_URL + "myWish"
var REQUEST_ADD_TO_WISH_LIST = USED_URL + "addWish"
var REQUEST_DELETE_FROM_WISH_LIST = USED_URL + "deleteWish"
var REQUEST_GET_PLACES = USED_URL + "place"
var REQUEST_GET_CURRENCIES = USED_URL + "currency"
var REQUEST_SET_ORDER = USED_URL + "order"
var REQUEST_SET_ORDER_UNREG = USED_URL + "orderNotRegistered"
var REQUEST_SEARCH = USED_URL + "search"
var REQUEST_BILL = USED_URL + "bill"
var REQUEST_BILL_REGISTERED = USED_URL + "billRegistered"
var REQUEST_MY_ADDRESSES = USED_URL + "myAddresses"
var REQUEST_SHIPPING_COMPANY = USED_URL + "shippingCompany"
var REQUEST_MY_ORDERS = USED_URL + "orders"
var REQUEST_TRACK_ORDERS = USED_URL + "track"
var REQUEST_TODAY_HOT_DEALS = USED_URL + "todayHotDeals"
var REQUEST_CHANGE_PASSWORD = USED_URL + "changePassword"
var REQUEST_CHANGE_IMAGE = USED_URL + "changeImage"
var REQUEST_CHANGE_INFO = USED_URL + "updateInfo"
var REQUEST_PROMOTIONS = USED_URL + "promotion"
var REQUEST_TODAY_TRENDING = USED_URL + "todayTrending"
var REQUEST_BEST_SELLER = USED_URL + "bestSeller"
var REQUEST_NEW_ARRIVALS = USED_URL + "newArrivals"
var REQUEST_TAKE_PROMOTION = USED_URL + "takePromotion"
var REQUEST_LOCATION_INFO = USED_URL + "locationInfo"
var REQUEST_CHECK_STORE_CREDIT = USED_URL + "checkStoreCredit"
var REQUEST_GET_STORE_CREDIT = USED_URL + "getStoreCredit"
var REQUEST_GET_LANGUAGES = USED_URL + "lang"
var REQUEST_GET_SLIDER_IMAGES = USED_URL + "slider"
var REQUEST_GET_HOME_PRODUCTS = USED_URL + "homeProducts"
var REQUEST_GET_ADS = USED_URL + "elanat"
var REQUEST_GET_AD_REG = USED_URL + "takeElanRegistered"
var REQUEST_GET_AD_UNREG = USED_URL + "takeElanUnRegistered"
var REQUEST_ADD_AD = USED_URL + "addElan"
var REQUEST_CONTACT_US = USED_URL + "contactUs"
var REQUEST_LANGUAGE_FILE = USED_URL + "langFile"

const val SYSTEM_PASSCODE = "PYxqb@vb"
const val ATTR_SYSTEM_PASSCODE = "SystemPasscode"
const val ATTR_ERROR_CODE = "ErrorCode"
const val ATTR_ERROR_MESSAGE = "ErrorMessage"
const val ATTR_EMAIL = "Email"
const val ATTR_PASSWORD = "Password"
const val ATTR_ID = "ID"
const val ATTR_P_CAT_ID = "ParentCategoryID"
const val ATTR_CURRANCY_ID = "CurrancyID"
const val ATTR_CURRENCY_ID = "CurrencyID"
const val ATTR_CURRENCY_NAME = "CurrencyName"
const val ATTR_FULLNAME = "Fullname"
const val ATTR_ZIPCODE = "ZipCode"
const val ATTR_INSURANCE_NAME = "InsuranceName"
const val ATTR_INSURANCE_NUMBER = "InsuranceNumber"
const val ATTR_IMAGE_URL = "ImageURL"
const val ATTR_MOBILE_IMAGE_URL = "MobileImageURL"
const val ATTR_WEB_IMAGE_URL = "WebImageURL"
const val ATTR_IMAGE = "Image"
const val ATTR_DATA = "Data"
const val ATTR_PRODUCT = "Product"
const val ATTR_IS_ANDROID = "IsAndroid"
const val ATTR_IS_RECTANGLE = "IsRectangle"
const val ATTR_TOKEN = "Token"
const val ATTR_PRODUCTS = "Products"
const val ATTR_FRAGMENT_INDEX = "FragmentIndex"
const val ATTR_CHILD = "Child"
const val ATTR_COLOR_ID = "ColorID"
const val ATTR_COLOR_URL = "ColorURL"
const val ATTR_PRODUCT_IMAGES = "ProductImages"
const val ATTR_FILE = "File"
const val ATTR_BRAND_ID = "BrandID"
const val ATTR_CONTENT = "Content"
const val ATTR_PRICE = "Price"
const val ATTR_PRICE_BEFORE_SALE = "PriceBeforeSale"
const val ATTR_SKU = "SKU"
const val ATTR_ADDED_DATE_TIME = "AddDateTime"
const val ATTR_RETURN_POLICY_DAYS = "ReturnPolicyDays"
const val ATTR_RETURN_POLICY_TEXT = "ReturnPolicyText"
const val ATTR_EXP_DATE = "ExpDate"
const val ATTR_IS_PHARMA = "IsPharma"
const val ATTR_IS_OFFER = "IsOffer"
const val ATTR_IS_NEW = "IsNew"
const val ATTR_IMAGES = "Images"
const val ATTR_NO_COLOR = "NoColor"
const val ATTR_COLOR = "Color"
const val ATTR_IS_ACCEPT_PROMOTION = "IsAcceptPromotion"
const val ATTR_CATEGORY_ID = "CategoryID"
const val ATTR_CUSTOMER = "Customer"
const val ATTR_CODE = "Code"
const val ATTR_LAT = "Lat"
const val ATTR_LON = "Lon"
const val ATTR_CITY = "City"
const val ATTR_REGION = "Region"
const val ATTR_TAX = "Tax"
const val ATTR_POINT_TO_AED = "PointToAED"
const val ATTR_NAME = "Name"
const val ATTR_PHONE = "Phone"
const val ATTR_MOBILE = "Mobile"
const val ATTR_REGION_ID = "RegionID"
const val ATTR_CITY_ID = "CityID"
const val ATTR_COUNTRY_ID = "CountryID"
const val ATTR_BRAND_NAME = "BrandName"
const val ATTR_COUNTRY = "Country"
const val ATTR_QTYS = "QTYs"
const val ATTR_COLORS = "Colors"
const val ATTR_QTY = "QTY"
const val ATTR_CURRENCY = "Currency"
const val ATTR_ADDRESS = "Address"
const val ATTR_IS_WISHED = "IsWished"
const val ATTR_TEXT = "Text"
const val ATTR_IS_UNREGISTERED = "IsUnregistered"
const val ATTR_TEL = "Tel"
const val ATTR_LOGO_URL = "LogoURL"
const val ATTR_WEBSITE_URL = "WebsiteURL"
const val ATTR_ORDER_NUMBER = "OrderNumber"
const val ATTR_AWB_NUMBER = "AWBNumber"
const val ATTR_ADD_DATE_TIME = "AddDateTime"
const val ATTR_STATUS = "Status"
const val ATTR_ACCOUNTABLE_TYPE = "AccountableType"
const val ATTR_ORDER = "Order"
const val ATTR_PRICE_ON_SALE = "PriceOnSale"
const val ATTR_INVOICE_DETAILS = "InvoiceDetails"
const val ATTR_OLD_PASSWORD = "OldPassword"
const val ATTR_NEW_PASSWORD = "NewPassword"
const val ATTR_TYPE = "Type"
const val ATTR_WORTH = "Worth"
const val ATTR_TOTAL_OF_INVOICE = "TotalOfInvoice"
const val ATTR_PUBLIC_CODE = "PublicCode"
const val ATTR_PRIVATE_CODE = "PrivateCode"
const val ATTR_START_AT = "StartAt"
const val ATTR_END_AT = "EndAt"
const val ATTR_PROMOTION = "Promotion"
const val ATTR_sYMBOL = "symbol"
const val ATTR_SYMBOL = "Symbol"
const val ATTR_PRIVATE = "Private"
const val ATTR_PUBLIC = "Public"
const val ATTR_TOTAL = "Total"
const val ATTR_LANGUAGE = "Language"
const val ATTR_STORE_CREDIT = "StoreCredit"
const val ATTR_URL = "ATTR_URL"
const val ATTR_SHIPPING_COMPANY = "ShippingCompany"
const val ATTR_FINAL_BILL = "FinalBill"
const val ATTR_COVERED_BY_STORE_CREDIT = "CoveredByStoreCredit"
const val ATTR_REMAINING_BILL = "RemainingBill"
const val ATTR_REMAINING_STORE_CREDIT = "YourStoreCreditIs"
const val ATTR_ADDED_STORE_CREDIT = "AddedStoreCredit"
const val ATTR_TITLE = "Title"
const val ATTR_PIXEL_SIZE = "PixelSize"
const val ATTR_AD = "Ad"
const val ATTR_ELAN = "Elan"
const val ATTR_TITLE_1 = "Title1"
const val ATTR_TITLE_2 = "Title2"
const val ATTR_TITLE_3 = "Title3"
const val ATTR_NUMBER_OF_DAYS = "NumberOfDays"
const val ATTR_MESSAGE = "Message"

// API Response ErrorCodes:
const val CODE_OK = 0
const val CODE_AUTHENTICATION = 1
const val CODE_MISSING_DATA = 2
const val CODE_USER_OR_PASSWORD_INCORRECT = 3
const val CODE_VERIFY_ACCOUNT_VIA_EMAIL = 4
const val CODE_ACCOUNT_DEACTIVATED = 5
const val CODE_SERVER_ERROR = 6
const val CODE_EMAIL_ALREADY_EXISTS = 7
const val CODE_FILE_EXTENSION_NOT_SUPPORTED = 8
const val CODE_PROMOTION_EXPIRED = 18
const val CODE_PRODUCTS_ARENT_IN_PROMOTION = 19
const val CODE_NO_STORE_CREDIT = 20

object Language {
    const val toast_done_check_email = "toast_done_check_email"
    const val toast_added_to_cart = "toast_added_to_cart"
    const val toast_password_updated = "toast_password_updated"
    const val toast_done = "toast_done"
    const val toast_order_sent = "toast_order_sent"
    const val toast_wait_for_confirmation_email = "toast_wait_for_confirmation_email"
    const val toast_password_email_sent = "toast_password_email_sent"
    const val toast_added_to_wishlist = "toast_added_to_wishlist"
    const val toast_removed_from_wishlist = "toast_removed_from_wishlist"
    const val toast_success_ad_request_sent = "toast_success_ad_request_sent"
    const val toast_item_removed_from_cart = "toast_item_removed_from_cart"

    const val hint_address = "hint_address"
    const val hint_zip_code = "hint_zip_code"
    const val hint_phone_optional = "hint_phone_optional"
    const val hint_mobile_optional = "hint_mobile_optional"
    const val hint_insurance_number = "hint_insurance_number"
    const val hint_insurance_name = "hint_insurance_name"
    const val hint_public_promotion_code = "hint_public_promotion_code"
    const val hint_private_promotion_code = "hint_private_promotion_code"
    const val hint_full_name = "hint_full_name"
    const val hint_phone = "hint_phone"
    const val hint_mobile = "hint_mobile"
    const val hint_currency = "hint_currency"
    const val hint_shipping_companies = "hint_shipping_companies"
    const val hint_name = "hint_name"
    const val hint_email = "hint_email"
    const val hint_languages = "hint_languages"
    const val hint_tel = "hint_tel"
    const val hint_type = "hint_type"
    const val hint_size = "hint_size"
    const val hint_title = "hint_title"
    const val hint_number_of_days = "hint_number_of_days"
    const val hint_content = "hint_content"
    const val hint_your_message = "hint_your_message"
    const val hint_new_password_confirmation = "hint_new_password_confirmation"
    const val hint_new_password = "hint_new_password"
    const val hint_old_password = "hint_old_password"
    const val hint_confirm_password = "hint_confirm_password"
    const val hint_password = "hint_password"

    const val attr_subtotal = "attr_subtotal"
    const val attr_discount = "attr_discount"
    const val attr_delivery = "attr_delivery"
    const val attr_total = "attr_total"
    const val attr_payment_information = "attr_payment_information"
    const val attr_full_name_ = "attr_full_name_"
    const val attr_card_number = "attr_card_number"
    const val attr_personal_information = "attr_personal_information"
    const val attr_country = "attr_country"
    const val attr_city = "attr_city"
    const val attr_total_price = "attr_total_price"
    const val attr_suggested_items = "attr_suggested_items"
    const val attr_send_password_rest_email = "attr_send_password_rest_email"
    const val attr_products = "attr_products"
    const val attr_colors = "attr_colors"
    const val attr_region = "attr_region"
    const val attr_phone = "attr_phone"
    const val attr_location = "attr_location"
    const val attr_currency = "attr_currency"
    const val attr_search_by = "attr_search_by"
    const val attr_total_price_is = "attr_total_price_is"
    const val attr_select_location_from = "attr_select_location_from"
    const val attr_favorite_locations = "attr_favorite_locations"
    const val attr_shipping_company = "attr_shipping_company"
    const val attr_order_number = "attr_order_number"
    const val attr_awb_number = "attr_awb_number"
    const val attr_status = "attr_status"
    const val attr_address = "attr_address"
    const val attr_accountable_type = "attr_accountable_type"
    const val attr_name = "attr_name"
    const val attr_tel = "attr_tel"
    const val attr_mobile = "attr_mobile"
    const val attr_quantity = "attr_quantity"
    const val attr_select_quantity = "attr_select_quantity"
    const val attr_remaining_is = "attr_remaining_is"
    const val attr_payment = "attr_payment"
    const val attr_languages = "attr_languages"
    const val attr_final_bill = "attr_final_bill"
    const val attr_remaining_store_credit = "attr_remaining_store_credit"
    const val attr_remaining_bill = "attr_remaining_bill"
    const val attr_today_s_hot_deals = "attr_today_s_hot_deals"
    const val attr_promotions = "attr_promotions"
    const val attr_title = "attr_title"
    const val attr_advertiser = "attr_advertiser"
    const val attr_added_store_credit = "attr_added_store_credit"
    const val attr_order_date = "attr_order_date"
    const val attr_start_at = "attr_start_at"
    const val attr_err_image_size = "attr_err_image_size"
    const val attr_type = "attr_type"
    const val attr_size = "attr_size"
    const val attr_description = "attr_description"
    const val attr_expiry_date = "attr_expiry_date"
    const val attr_return_policy = "attr_return_policy"
    const val attr_return_days = "attr_return_days"

    const val btn_forgot_password = "btn_forgot_password"
    const val btn_log_out = "btn_log_out"
    const val btn_send = "btn_send"
    const val btn_get_ad = "btn_get_ad"
    const val btn_share_ad = "btn_share_ad"
    const val btn_request_ad = "btn_request_ad"
    const val btn_share = "btn_share"
    const val btn_send_message = "btn_send_message"
    const val btn_cash = "btn_cash"
    const val btn_gateway = "btn_gateway"
    const val btn_configure_payment = "btn_configure_payment"
    const val btn_submit_to_promotion = "btn_submit_to_promotion"
    const val btn_change_password = "btn_change_password"
    const val btn_calculate_order = "btn_calculate_order"
    const val btn_proceed = "btn_proceed"
    const val btn_sign_in = "btn_sign_in"
    const val btn_skip = "btn_skip"
    const val btn_sign_up = "btn_sign_up"
    const val btn_sign_in_or_sign_up = "btn_sign_in_or_sign_up"
    const val btn_log_in = "btn_log_in"
    const val btn_add_to_cart = "btn_add_to_cart"
    const val btn_undo = "btn_undo"
    const val btn_place_order = "btn_place_order"
    const val btn_check_out = "btn_check_out"
    const val btn_gps = "btn_gps"
    const val btn_favorites = "btn_favorites"
    const val btn_manually = "btn_manually"

    const val menu_cart = "menu_cart"
    const val menu_notifications = "menu_notifications"
    const val menu_search = "menu_search"

    const val prompt_not_logged_in = "prompt_not_logged_in"
    const val prompt_send_photos = "prompt_send_photos"
    const val prompt_please_retry = "prompt_please_retry"
    const val prompt_send_photo = "prompt_send_photo"

    const val dialog_use_store_credit = "dialog_use_store_credit"
    const val dialog_confirm_remove_from_wish_list = "dialog_confirm_remove_from_wish_list"
    const val dialog_rationale_share_photos = "dialog_rationale_share_photos"
    const val dialog_use_promotion_code = "dialog_use_promotion_code"
    const val dialog_getting_location_info = "dialog_getting_location_info"
    const val dialog_take_promotion = "dialog_take_promotion"
    const val dialog_loading = "dialog_loading"
    const val dialog_update_name = "dialog_update_name"
    const val dialog_update_mobile_number = "dialog_update_mobile_number"
    const val dialog_update_phone_number = "dialog_update_phone_number"
    const val dialog_getting_location = "dialog_getting_location"
    const val dialog_proceed_to_check_out = "dialog_proceed_to_check_out"
    const val dialog_confirm_log_out = "dialog_confirm_log_out"
    const val dialog_logging_out = "dialog_logging_out"
    const val dialog_product_already_exists = "dialog_product_already_exists"

    const val dialog_opt_request_another = "dialog_opt_request_another"
    const val dialog_opt_cancel = "dialog_opt_cancel"
    const val dialog_opt_view_image = "dialog_opt_view_image"
    const val dialog_opt_upload_from_camera = "dialog_opt_upload_from_camera"
    const val dialog_opt_upload_from_gallery = "dialog_opt_upload_from_gallery"
    const val dialog_opt_update = "dialog_opt_update"
    const val dialog_opt_camera = "dialog_opt_camera"
    const val dialog_opt_no = "dialog_opt_no"
    const val dialog_opt_yes = "dialog_opt_yes"
    const val dialog_opt_gallery = "dialog_opt_gallery"
    const val dialog_opt_ok = "dialog_opt_ok"
    const val dialog_opt_pick_file = "dialog_opt_pick_file"

    const val err_products_not_in_promotion = "err_products_not_in_promotion"
    const val err_promotion_expired = "err_promotion_expired"
    const val err_username_password_incorrect = "err_username_password_incorrect"
    const val err_no_selected_photo = "err_no_selected_photo"
    const val err_no_name = "err_no_name"
    const val err_no_email = "err_no_email"
    const val err_no_tel = "err_no_tel"
    const val err_no_mobile = "err_no_mobile"
    const val err_no_title = "err_no_title"
    const val err_no_start_date = "err_no_start_date"
    const val err_no_number_of_days = "err_no_number_of_days"
    const val err_number_of_days_too_large = "err_number_of_days_too_large"
    const val err_specify_region = "err_specify_region"
    const val err_not_logged_in_missing_info = "err_not_logged_in_missing_info"
    const val err_currency_not_specified = "err_currency_not_specified"
    const val err_address_not_specified = "err_address_not_specified"
    const val err_some_fields_are_empty = "err_some_fields_are_empty"
    const val err_generic_error = "err_generic_error"
    const val err_password_too_short = "err_password_too_short"
    const val err_email_address_invalid = "err_email_address_invalid"
    const val err_file_pick_failed = "err_file_pick_failed"
    const val err_passwords_dont_match = "err_passwords_dont_match"
    const val err_server_connection_error = "err_server_connection_error"
    const val err_no_internet_connection = "err_no_internet_connection"
    const val err_no_location = "err_no_location"
    const val err_no_shipping_company = "err_no_shipping_company"
    const val err_empty_fields = "err_empty_fields"
    const val err_password_length = "err_password_length"
    const val err_email_already_exists = "err_email_already_exists"
    const val err_failed_sharing = "err_failed_sharing"
    const val err_no_message = "err_no_message"

    const val nav_todays_hot_deals = "nav_todays_hot_deals"
    const val nav_ads = "nav_ads"
    const val nav_settings = "nav_settings"
    const val nav_my_orders = "nav_my_orders"
    const val nav_home = "nav_home"
    const val nav_your_orders = "nav_your_orders"
    const val nav_your_wish_list = "nav_your_wish_list"
    const val nav_your_account = "nav_your_account"
    const val nav_shop_by_category = "nav_shop_by_category"
    const val nav_promotions = "nav_promotions"
    const val nav_categories = "nav_categories"
    const val nav_wish_list = "nav_wish_list"
    const val nav_purchase_history = "nav_purchase_history"
    const val nav_header_title = "nav_header_title"
    const val nav_header_desc = "nav_header_desc"
    const val nav_contact_us = "nav_contact_us"

    const val txt_v_gold_ads = "txt_v_gold_ads"
    const val txt_v_all_categories = "txt_v_all_categories"
    const val txt_v_tracking = "txt_v_tracking"
    const val txt_v_details_of = "txt_v_details_of"
    const val txt_v_track_order = "txt_v_track_order"
    const val txt_v_order_details = "txt_v_order_details"
    const val txt_v_store_credit_covered = "txt_v_store_credit_covered"
    const val txt_v_no_store_credit = "txt_v_no_store_credit"
    const val txt_v_no_gold_ads = "txt_v_no_gold_ads"
    const val txt_v_silver_ads = "txt_v_silver_ads"
    const val txt_v_no_silver_ads = "txt_v_no_silver_ads"
    const val txt_v_no_color = "txt_v_no_color"
    const val txt_v_no_data = "txt_v_no_data"
    const val txt_v_cart_is_empty = "txt_v_cart_is_empty"
    const val txt_v_no_categories = "txt_v_no_categories"
    const val txt_v_bronze_ads = "txt_v_bronze_ads"
    const val txt_v_no_bronze_ads = "txt_v_no_bronze_ads"
    const val txt_v_select_date = "txt_v_select_date"
    const val txt_v_select_photo = "txt_v_select_photo"
    const val txt_v_covered_by_store_credit = "txt_v_covered_by_store_credit"
    const val txt_v_welcome = "txt_v_welcome"
    const val txt_v_best_sellers = "txt_v_best_sellers"
    const val txt_v_more_from = "txt_v_more_from"
    const val txt_Submit = "txt_Submit"
    const val txt_v_new_arrival = "txt_v_new_arrival"
    const val txt_v_select_color = "txt_v_select_color"
    const val txt_today_trending = "txt_today_trending"
    const val txt_enter_awb = "txt_enter_awb"
    const val txt_hot_deal = "txt_hot_deal"
    const val txt_purchased = "txt_purchased"
    const val txt_track_your_rders = "txt_track_your_rders"
    const val txt_help = "txt_help"
}

public inline fun CharSequence?.isNullOrEmptyOrStringNull(): Boolean {
    return this == null || this.length == 0 || this.toString().toLowerCase() == "null"
}