package com.autotech.we1l.tools

import android.content.Context
import android.support.v4.widget.CircularProgressDrawable
import android.widget.ImageView
import com.squareup.picasso.Callback

import com.squareup.picasso.Picasso
import com.squareup.picasso.Target

object PicassoUtils {

    fun getImage(imgUrl: String, context: Context, imageView: ImageView, centerCrop: Boolean = true) {
        getImage(imgUrl, context, imageView, null, centerCrop)
    }

    fun getImage(imgUrl: String, context: Context, imageView: ImageView, callback: Callback?, centerCrop: Boolean) {

        val picasso = Picasso.get().load(imgUrl)

        if (centerCrop) picasso.fit().centerCrop()

        picasso.placeholder(buildCircularProgressDrawable(context))
                .into(imageView, callback)
    }

    fun getBitmap(imgUrl: String, target: Target) {
        Picasso.get().load(imgUrl).into(target)
    }

    fun invalidate(imgUrl: String) {
        Picasso.get()
                .invalidate(imgUrl)
    }

    private fun buildCircularProgressDrawable(context: Context): CircularProgressDrawable {
        val drawable = CircularProgressDrawable(context)
        drawable.strokeWidth = 5.0f
        drawable.centerRadius = 36.0f
        drawable.start()

        return drawable
    }

}
