package com.autotech.we1l.tools

import android.content.Context
import android.content.Intent
import android.net.ConnectivityManager
import android.net.NetworkInfo
import android.os.Parcelable
import android.support.v7.app.AppCompatActivity
import com.autotech.we1l.activities.FirstScreenActivity
import com.autotech.we1l.activities.MainActivity
import com.autotech.we1l.activities.PlaceHolderActivity
import com.autotech.we1l.activities.SearchActivity
import com.autotech.we1l.items.Order
import com.autotech.we1l.my_classes.BaseItem
import com.autotech.we1l.my_classes.BaseList

fun <T> isObjectNull(yourObject: T?): Boolean {
    return yourObject == null
}

fun launchCart(context: Context) {
    context.startActivity(Intent(context, PlaceHolderActivity::class.java)
            .putExtra(PlaceHolderActivity.FRAGMENT_TYPE, PlaceHolderActivity.TYPE_CART))
}

fun launchNotifications(context: Context) {
    context.startActivity(Intent(context, PlaceHolderActivity::class.java)
            .putExtra(PlaceHolderActivity.FRAGMENT_TYPE, PlaceHolderActivity.TYPE_NOTIFICATIONS))
}

fun launchProductDetails(context: Context, productId: String) {
    context.startActivity(Intent(context, PlaceHolderActivity::class.java)
            .putExtra(PlaceHolderActivity.FRAGMENT_TYPE, PlaceHolderActivity.TYPE_FULL_ITEM)
            .putExtra(ATTR_PRODUCT, productId))
}

//fun launchProductDetails(context: Context, product: CartProduct) {
//    context.startActivity(Intent(context, PlaceHolderActivity::class.java)
//            .putExtra(PlaceHolderActivity.FRAGMENT_TYPE, PlaceHolderActivity.TYPE_FULL_ITEM)
//            .putExtra(ATTR_PRODUCT, product))
//}

fun launchMainActivity(context: Context) {
    context.startActivity(Intent(context, MainActivity::class.java).addFlags(Intent.FLAG_ACTIVITY_NEW_TASK))
    (context as AppCompatActivity).finish()
}

fun launchFirstActivity(context: Context) {
    context.startActivity(Intent(context, FirstScreenActivity::class.java))
    (context as AppCompatActivity).finish()
}

fun launchSearchActivity(context: Context) {
    context.startActivity(Intent(context, SearchActivity::class.java).addFlags(Intent.FLAG_ACTIVITY_NEW_TASK))
}

fun launchCheckOut(context: Context, price: Float, publicCode: String, privateCode: String) {
    context.startActivity(Intent(context, PlaceHolderActivity::class.java)
            .putExtra(PlaceHolderActivity.FRAGMENT_TYPE, PlaceHolderActivity.TYPE_CHECK_OUT)
            .putExtra(ATTR_PRICE, price)
            .putExtra(ATTR_PUBLIC_CODE, publicCode)
            .putExtra(ATTR_PRIVATE_CODE, privateCode))
}

fun launchTrackOrders(context: Context, order: Order) {
    context.startActivity(Intent(context, PlaceHolderActivity::class.java)
            .putExtra(PlaceHolderActivity.FRAGMENT_TYPE, PlaceHolderActivity.TYPE_TRACK_ORDER)
            .putExtra(ATTR_ORDER, order))
}

fun launchOrderDetails(context: Context, order: Order) {
    context.startActivity(Intent(context, PlaceHolderActivity::class.java)
            .putExtra(PlaceHolderActivity.FRAGMENT_TYPE, PlaceHolderActivity.TYPE_ORDER_DETAILS)
            .putExtra(ATTR_ORDER, order))
}

fun launchRequestAd(context: Context) {
    context.startActivity(Intent(context, PlaceHolderActivity::class.java)
            .putExtra(PlaceHolderActivity.FRAGMENT_TYPE, PlaceHolderActivity.TYPE_REQUEST_AD))
}

fun <T> arrayToArrayList(array: Array<T>): ArrayList<T> {
    val arrayList = ArrayList<T>()
    array.forEachIndexed { _, t ->
        arrayList.add(t)
    }
    return arrayList
}

fun <T : BaseItem> arrayToMyList_Parcelable(array: Array<Parcelable>): BaseList<T> {
    val arrayList = BaseList<T>()
    array.forEachIndexed { _, t ->
        arrayList.add(t as T)
    }
    return arrayList
}

fun setupLinks(which: Int) {
    val base = when (which) {
        0 -> {
            isLocal = true
            LOCAL_URL
        }
        1 -> {
            isLocal = false
            WEB_URL
        }
        else -> {
            isLocal = true
            LOCAL_URL
        }
    }

    REQUEST_LOG_IN = base + "login"
    REQUEST_SIGN_UP = base + "signup"
    REQUEST_LOG_OUT = base + "logout"
    REQUEST_FORGOT_PASSWORD = base + "forget"
    REQUEST_GET_CATEGORIES = base + "categories"
    REQUEST_GET_CATEGORY = base + "category"
    REQUEST_GET_WISH_LIST = base + "myWish"
    REQUEST_ADD_TO_WISH_LIST = base + "addWish"
    REQUEST_DELETE_FROM_WISH_LIST = base + "deleteWish"
    REQUEST_GET_PLACES = base + "place"
    REQUEST_GET_CURRENCIES = base + "currency"
    REQUEST_SET_ORDER = base + "order"
    REQUEST_SEARCH = base + "search"
    REQUEST_BILL = base + "bill"
    REQUEST_MY_ADDRESSES = base + "myAddresses"
    REQUEST_SHIPPING_COMPANY = base + "shippingCompany"
    REQUEST_MY_ORDERS = base + "orders"
    REQUEST_TRACK_ORDERS = base + "track"
    REQUEST_TODAY_HOT_DEALS = base + "todayHotDeals"
    REQUEST_CHANGE_PASSWORD = base + "changePassword"
    REQUEST_CHANGE_IMAGE = base + "changeImage"
    REQUEST_CHANGE_INFO = base + "changeInfo"
    REQUEST_PROMOTIONS = base + "promotion"
    REQUEST_TAKE_PROMOTION = base + "takePromotion"
    REQUEST_CHECK_STORE_CREDIT = base + "checkStoreCredit"
}

fun isNetworkAvailable(context: Context): Boolean {
    val connectivityManager = context.getSystemService(Context.CONNECTIVITY_SERVICE) as ConnectivityManager
    val activeNetworkInfo: NetworkInfo? = connectivityManager.activeNetworkInfo
    return activeNetworkInfo != null && activeNetworkInfo.isConnected
}
