package com.autotech.we1l.tools

import android.content.Intent
import android.graphics.Bitmap
import android.graphics.drawable.Drawable
import android.net.Uri
import android.os.Environment
import android.support.v4.app.Fragment
import android.support.v4.content.FileProvider
import android.support.v7.app.AppCompatActivity
import android.widget.Toast
import com.autotech.we1l.R
import com.autotech.we1l.app.AppLanguage
import com.autotech.we1l.tools.Language.dialog_rationale_share_photos
import com.autotech.we1l.tools.Language.err_failed_sharing
import com.squareup.picasso.Picasso
import com.squareup.picasso.Target
import pub.devrel.easypermissions.EasyPermissions
import java.io.ByteArrayOutputStream
import java.io.File
import java.io.FileOutputStream
import java.io.IOException
import java.util.*


object ShareFileUtil {

    val permissions = arrayOf(android.Manifest.permission.WRITE_EXTERNAL_STORAGE)

    const val WRITE_PERMISSIONS_SHARE_CODE = 3

    fun shareFile(host: Fragment, imageUrl: String, text: String, id: String) {
        PicassoUtils.getBitmap(imageUrl, object : Target {
            override fun onPrepareLoad(placeHolderDrawable: Drawable?) {

            }

            override fun onBitmapFailed(e: Exception?, errorDrawable: Drawable?) {
                Toast.makeText(host.context, AppLanguage.getString(err_failed_sharing), Toast.LENGTH_LONG).show()
            }

            override fun onBitmapLoaded(bitmap: Bitmap?, from: Picasso.LoadedFrom?) {
                shareFile(host, bitmap!!, text, id)
            }
        })

    }

    fun shareFile(host: Fragment, bitmap: Bitmap, text: String, id: String) {
        val share = Intent(Intent.ACTION_SEND)
        share.type = "image/jpeg"
        val bytes = ByteArrayOutputStream()
        bitmap.compress(Bitmap.CompressFormat.JPEG, 50, bytes)
        val sharedFileDir = File(host.context?.cacheDir?.absolutePath + FOLDER_NAME + SENT_FILES_FOLDER_NAME)
        var sharedFile: File? = null

        try {
            if (!sharedFileDir.exists()) sharedFileDir.mkdirs()

            sharedFile = File(sharedFileDir, Calendar.getInstance().timeInMillis.toString() + ".jpg")
            sharedFile.createNewFile()
            val fo = FileOutputStream(sharedFile)
            fo.write(bytes.toByteArray())
            fo.flush()
            fo.close()
        } catch (e: IOException) {
        }

        share.putExtra(Intent.EXTRA_SUBJECT, host.getString(R.string.share))
        share.putExtra(Intent.EXTRA_TEXT, host.getString(R.string.share_item, text, id))
        if (android.os.Build.VERSION.SDK_INT < android.os.Build.VERSION_CODES.N) {
            share.putExtra(Intent.EXTRA_STREAM, Uri.fromFile(sharedFile))
            host.startActivity(Intent.createChooser(share, host.getString(R.string.share)))
        } else {
            share.putExtra(Intent.EXTRA_STREAM, FileProvider.getUriForFile(host.context!!, FILE_PROVIDER, sharedFile!!))
            host.startActivity(Intent.createChooser(share, host.getString(R.string.share)))
        }
    }

}