package com.autotech.we1l.tools;

import android.annotation.SuppressLint;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.os.Build;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.util.Patterns;
import android.webkit.MimeTypeMap;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;

import static com.autotech.we1l.tools.ConstantsKt.CHANNEL_ID;

public class Tools {

    private static final String DATE_FORMAT_DATE = "yyyy-MM-dd";
    private static final String DATE_FORMAT_TIME = "HH:mm:ss";
    private static final String DATE_FORMAT_DATE_TIME = DATE_FORMAT_DATE + " " + DATE_FORMAT_TIME;

    public static Calendar utcToCalendar(Long time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        return calendar;
    }

    @SuppressLint("SimpleDateFormat")
    public static String calendarToString_Date(Calendar calendar) {
        return new SimpleDateFormat(DATE_FORMAT_DATE).format(calendar.getTime());
    }

    @SuppressLint("SimpleDateFormat")
    public static String calendarToString_Time(Calendar calendar) {
        return new SimpleDateFormat(DATE_FORMAT_TIME).format(calendar.getTime());
    }

    @SuppressLint("SimpleDateFormat")
    public static String calendarToString_FullDate(Calendar calendar) {
        return new SimpleDateFormat(DATE_FORMAT_DATE_TIME).format(calendar.getTime());
    }

    @SuppressLint("SimpleDateFormat")
    public static Calendar stringToCalendar_FullDate(String date) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new SimpleDateFormat(DATE_FORMAT_DATE_TIME).parse(date));
        return calendar;
    }

    @SuppressLint("SimpleDateFormat")
    public static Calendar stringToCalendar_Time(String date) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new SimpleDateFormat(DATE_FORMAT_TIME).parse(date));
        return calendar;
    }

    @SuppressLint("SimpleDateFormat")
    public static Calendar stringToCalendar_Date(String date) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new SimpleDateFormat(DATE_FORMAT_DATE).parse(date));
        return calendar;
    }

    public static <T extends RecyclerView.ViewHolder> void setupRV(RecyclerView recyclerView, RecyclerView.Adapter<T> adapter) {
        recyclerView.setAdapter(adapter);
        recyclerView.setLayoutManager(new LinearLayoutManager(recyclerView.getContext()));
    }

    public static <T extends RecyclerView.Adapter<V>, V extends RecyclerView.ViewHolder> void setupRV(RecyclerView recyclerView, T adapter, RecyclerView.LayoutManager layoutManager) {
        recyclerView.setAdapter(adapter);
        recyclerView.setLayoutManager(layoutManager);
    }

    public static <T extends RecyclerView.ViewHolder> void setupRVReversed(RecyclerView recyclerView, RecyclerView.Adapter<T> adapter) {
        recyclerView.setAdapter(adapter);
        LinearLayoutManager layoutManager = new LinearLayoutManager(recyclerView.getContext());
        layoutManager.setReverseLayout(true);
        recyclerView.setLayoutManager(layoutManager);
    }

    public static <T extends RecyclerView.ViewHolder> void setupRVHorizontal(RecyclerView recyclerView, RecyclerView.Adapter<T> adapter) {
        recyclerView.setAdapter(adapter);
        LinearLayoutManager layoutManager = new LinearLayoutManager(recyclerView.getContext());
        layoutManager.setOrientation(LinearLayoutManager.HORIZONTAL);
        recyclerView.setLayoutManager(layoutManager);
    }

    public static <T extends RecyclerView.ViewHolder> void setUpRVGrid(RecyclerView recyclerView, RecyclerView.Adapter<T> adapter, int spanCount) {
        recyclerView.setAdapter(adapter);

        recyclerView.setLayoutManager(new GridLayoutManager(recyclerView.getContext(), spanCount));
        recyclerView.setHasFixedSize(true);
        recyclerView.setItemViewCacheSize(20);
        recyclerView.setDrawingCacheEnabled(true);
    }

    public static boolean isWithinSessionLength(int duration, Calendar sessionDate) {
        Calendar calendar = Calendar.getInstance();
        long timeDifference = calendar.getTimeInMillis() - sessionDate.getTimeInMillis();
        return timeDifference <= TimeUnit.MINUTES.toMillis(duration) && timeDifference >= 0;
    }

    public static void createNotificationsChannel(Context context) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            String channelName = "Prodygie";
            String channelDescription = "Prodygie";
            int importance = NotificationManager.IMPORTANCE_DEFAULT;
            NotificationChannel channel = new NotificationChannel(CHANNEL_ID, channelName, importance);
            channel.setDescription(channelDescription);
            NotificationManager notificationManager = context.getSystemService(NotificationManager.class);
            if ((notificationManager).getNotificationChannel(CHANNEL_ID) == null) {
                notificationManager.createNotificationChannel(channel);
            }
        }
    }

//    public static String generateDate(Context context, Calendar calendar) {
//        Calendar currCalendar = Calendar.getInstance();
//        int daysDifference = currCalendar.get(Calendar.DAY_OF_YEAR) - calendar.get(Calendar.DAY_OF_YEAR);
//        if (daysDifference > 1) {
//            return daysDifference + " " + context.getString(R.string.days_ago);
//        } else if (daysDifference == 1) {
//            return context.getString(R.string.yesterday);
//        } else if (daysDifference == 0) {
//            int hoursDifference = currCalendar.get(Calendar.HOUR_OF_DAY) - calendar.get(Calendar.HOUR_OF_DAY);
//            if (hoursDifference > 0) {
//                return hoursDifference + " " + context.getString(R.string.hours_ago);
//            } else if (hoursDifference == 0) {
//                int minutesDifference = currCalendar.get(Calendar.MINUTE) - calendar.get(Calendar.MINUTE);
//                if (minutesDifference > 0) {
//                    return minutesDifference + " " + context.getString(R.string.minutes_ago);
//                } else {
//                    return context.getString(R.string.just_now);
//                }
//            }
//        }
//        return calendarToString_Time(calendar);
//    }


    public static String getExtension(String path) {
        String path2 = path.replaceAll(" ", "%20");

        String extension = MimeTypeMap.getFileExtensionFromUrl(path2);
        if (extension.isEmpty()) {
            extension = path.substring(path.lastIndexOf(".") + 1);
        }
        return extension;
    }

    public static boolean isEmailValid(String email) {
        return !TextUtils.isEmpty(email) && Patterns.EMAIL_ADDRESS.matcher(email).matches();
    }

}