package com.autotech.we1l.volley

import com.android.volley.NetworkResponse
import com.android.volley.Request
import com.android.volley.Response
import com.android.volley.toolbox.HttpHeaderParser

class InputStreamVolleyRequest(mUrl: String?, listener: Response.Listener<ByteArray>, errorListener: Response.ErrorListener?)
    : Request<ByteArray>(Method.GET, mUrl, errorListener) {

    private val mListener: Response.Listener<ByteArray>
    private var responseHeaders: Map<String, String>? = null

    override fun deliverResponse(response: ByteArray) {
        mListener.onResponse(response)
    }

    override fun parseNetworkResponse(response: NetworkResponse): Response<ByteArray> {
        responseHeaders = response.headers

        return Response.success(response.data, HttpHeaderParser.parseCacheHeaders(response))
    }

    init {
        setShouldCache(false)
        mListener = listener
    }

}