package com.autotech.we1ldriver.adapters

import android.content.Context
import android.support.v7.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView

import com.autotech.we1ldriver.R
import com.autotech.we1ldriver.my_classes.InvoiceDetails
import com.autotech.we1ldriver.tools.Tools

class InvoiceDetailsAdapter(private var invoiceDetailsList: List<InvoiceDetails>?, private var onClickInvoiceDetails: OnClickInvoiceDetails) : RecyclerView.Adapter<InvoiceDetailsAdapter.InvoiceDetailsHolder>() {


    override fun onCreateViewHolder(viewGroup: ViewGroup, i: Int): InvoiceDetailsHolder {
        return InvoiceDetailsHolder(LayoutInflater.from(viewGroup.context).inflate(R.layout.viewholder_invoice_details, viewGroup, false))
    }

    override fun onBindViewHolder(invoiceDetailsHolder: InvoiceDetailsHolder, i: Int) {
        val invoiceDetails = invoiceDetailsList?.get(invoiceDetailsHolder.adapterPosition)
        val context: Context = invoiceDetailsHolder.itemView.context

        invoiceDetailsHolder.textViewName.text = invoiceDetails?.Product?.Name
        invoiceDetailsHolder.textViewQty.text = context.getString(R.string.quantity, invoiceDetails?.QTY)
        invoiceDetailsHolder.textViewTotalPrice.text = context.getString(R.string.price, invoiceDetails?.Product?.Price)
        invoiceDetailsHolder.textViewRefund.text = invoiceDetails?.Product?.ReturnPolicyText
        invoiceDetailsHolder.textViewShow.text = Tools.calendarToString_Date(Tools.stringToCalendar_Date(invoiceDetails?.Product?.AddDateTime))
    }

    override fun getItemCount(): Int {
        return invoiceDetailsList?.size!!
    }

    class InvoiceDetailsHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        val textViewName: TextView = itemView.findViewById(R.id.textViewName)
        val textViewQty: TextView = itemView.findViewById(R.id.textViewQty)
        val textViewTotalPrice: TextView = itemView.findViewById(R.id.textViewTotalPrice)
        val textViewShow: TextView = itemView.findViewById(R.id.textViewShow)
        val textViewRefund: TextView = itemView.findViewById(R.id.textViewRefund)
    }

    interface OnClickInvoiceDetails {
        fun onClick(invoiceDetails: InvoiceDetails)
    }

}
