package com.autotech.we1ldriver.adapters

import android.content.Context
import android.support.design.button.MaterialButton
import android.support.v7.util.SortedList
import android.support.v7.widget.AppCompatTextView
import android.support.v7.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Button
import android.widget.Filter
import android.widget.Filterable
import com.autotech.we1ldriver.R
import com.autotech.we1ldriver.items.Invoic
import com.autotech.we1ldriver.my_classes.Invoice
import com.autotech.we1ldriver.my_classes._MyAdapter
import com.autotech.we1ldriver.my_classes._MyList
import com.autotech.we1ldriver.my_classes._MyHolder
import com.autotech.we1ldriver.tools.Tools
import java.text.SimpleDateFormat
import java.util.*
import kotlin.collections.ArrayList

class InvoicesAdapter(var dataInvoices: List<Invoice>, private var onClickListener: OnClickListener) :
        RecyclerView.Adapter<InvoicesAdapter.InvoiceHolder>(), Filterable {


    private var dataInvoicesBasic: List<Invoice> = dataInvoices

    override fun getFilter(): Filter {
        return object : Filter() {
            override fun performFiltering(constraint: CharSequence): Filter.FilterResults? {
                val filterResults = FilterResults()
                val string: String = constraint.toString().trim()

                var dataInvoicesFiltered = ArrayList<Invoice>()
                val filteredList = ArrayList<Invoice>()

                if (dataInvoicesBasic == null) {
                    dataInvoices = ArrayList<Invoice>(dataInvoices)
                }

                if (!constraint.isEmpty()) {
                    if (dataInvoicesBasic.isNotEmpty()) {
                        for (i in 0 until dataInvoicesBasic.size) {
                            if (dataInvoicesBasic[i].OrderNumber?.toLowerCase()?.contains(string)!!) {
                                filteredList.add(dataInvoicesBasic[i])
                            }
                        }
                    }
                    filterResults.values = filteredList
                    filterResults.count = filteredList.size
                } else {
                    filterResults.values = dataInvoicesBasic
                    filterResults.count = dataInvoicesBasic.size
                }

                return filterResults
            }

            override fun publishResults(constraint: CharSequence, results: Filter.FilterResults) {
                dataInvoices = results.values as List<Invoice>
                notifyDataSetChanged()
            }
        }
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): InvoiceHolder {
        return InvoiceHolder(LayoutInflater.from(parent.context).inflate(R.layout.rv_invoice, parent, false))
    }

    override fun onBindViewHolder(holder: InvoiceHolder, p1: Int) {
        val invoice = dataInvoices[holder.adapterPosition]
        val context: Context = holder.itemView.context
        holder.textViewOrderNumber.text = context.getString(R.string.order_number, invoice.OrderNumber)
        holder.textViewAWBNumber.text = invoice.AWBNumber
        holder.textViewDate.text = context.getString(R.string.date, Tools.calendarToString_Date(Tools.stringToCalendar_Date(invoice.AddDateTime)))
        holder.textViewStatus.text = context.getString(R.string.current_status, invoice.Status)

        holder.changeStatus.setOnClickListener {
            onClickListener.onSpecialClick(holder.changeStatus, holder, holder.adapterPosition, invoice)
        }

        holder.itemView.setOnClickListener {
            onClickListener.onClick(holder, p1, invoice)
        }
    }

    override fun getItemCount(): Int {
        return dataInvoices.size
    }

    class InvoiceHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        val textViewOrderNumber: AppCompatTextView = itemView.findViewById(R.id.textViewOrderNumber)
        val textViewAWBNumber: AppCompatTextView = itemView.findViewById(R.id.textViewAWBNumber)
        val textViewDate: AppCompatTextView = itemView.findViewById(R.id.textViewDate)
        val textViewStatus: AppCompatTextView = itemView.findViewById(R.id.textViewStatus)
        val changeStatus: Button = itemView.findViewById(R.id.change_status)
    }

    interface OnClickListener {

        fun onClick(holder: RecyclerView.ViewHolder, position: Int, item: Invoice) {}

        fun onLongClick(holder: RecyclerView.ViewHolder, position: Int, item: Invoice) {}

        fun onSpecialClick(view: View, holder: RecyclerView.ViewHolder, position: Int, item: Invoice) {}
    }

    fun editInvoice(status: String, index: Int) {
        dataInvoices[index].Status = status
        notifyDataSetChanged()
    }

}