package com.autotech.we1ldriver.adapters

import android.support.v7.widget.RecyclerView
import android.view.LayoutInflater
import android.view.ViewGroup

import com.autotech.we1ldriver.R
import com.autotech.we1ldriver.my_classes.IStatus
import com.autotech.we1ldriver.my_classes.Status
import com.autotech.we1ldriver.view.viewHolder.StatusViewHolder

import org.jetbrains.annotations.Contract

class StatusAdapter(statusList: List<Status>, iStatus: IStatus) : RecyclerView.Adapter<StatusViewHolder>() {

    private var statusList: List<Status>? = null
    private var iStatus: IStatus? = null
    private var POSITION_SELECTED = -1

    init {
        this.statusList = statusList
        this.iStatus = iStatus
    }

    override fun onCreateViewHolder(viewGroup: ViewGroup, i: Int): StatusViewHolder {
        return StatusViewHolder(LayoutInflater.from(viewGroup.context).inflate(R.layout.viewholder_status, viewGroup, false))
    }

    override fun onBindViewHolder(statusViewHolder: StatusViewHolder, index: Int) {
        val status = statusList!![statusViewHolder.adapterPosition]

        statusViewHolder.radioButton.text = status.text

        statusViewHolder.radioButton.isEnabled = status.isEnabled

        if (status.isSelected) {
            statusViewHolder.radioButton.isChecked = true
            iStatus?.onClick(status)
            POSITION_SELECTED = statusViewHolder.adapterPosition
        } else
            statusViewHolder.radioButton.isChecked = false

        statusViewHolder.radioButton.setOnClickListener {
            if (POSITION_SELECTED == -1) {
                POSITION_SELECTED = statusViewHolder.adapterPosition
                statusList!![statusViewHolder.adapterPosition].isSelected = true
            } else {
                statusList!![POSITION_SELECTED].isSelected = false
                POSITION_SELECTED = statusViewHolder.adapterPosition
                statusList!![POSITION_SELECTED].isSelected = true
            }
            iStatus!!.onClick(status)

            notifyDataSetChanged()
        }
    }

    override fun getItemCount(): Int {
        return this.statusList!!.size
    }
}
