package com.autotech.we1ldriver.app;

import android.app.Application;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.support.v7.app.AppCompatActivity;

import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.toolbox.Volley;
import com.autotech.we1ldriver.my_classes.User;
import com.google.firebase.FirebaseApp;

import java.util.Locale;

public class MyApp extends Application {

    public static final String DATABASE_NAME = "Data", LOCALE = "Locale", LANGUAGE_ENGLISH = "en", LANGUAGE_PORTUGUESE = "pt";
    public static final Locale LOCALE_ENGLISH = new Locale("en"), LOCALE_PORTUGUESE = new Locale("pt", "PR");

    public static String language = LANGUAGE_ENGLISH;

    private User currentUser;

    private static final String TAG = MyApp.class.getSimpleName();

    private static MyApp instance;

    private RequestQueue mRequestQueue;

    @Override
    public void onCreate() {
        super.onCreate();
        instance = this;

        FirebaseApp.initializeApp(getApplicationContext());
    }

    public static MyApp getInstance() {
        return instance;
    }

    private RequestQueue getRequestQueue() {
        if (mRequestQueue == null) {
            mRequestQueue = Volley.newRequestQueue(getApplicationContext());
        }
        mRequestQueue.getCache().clear();
        return mRequestQueue;
    }

    public <T> void addToRequestQueue(Request<T> req) {
        req.setTag(TAG);
        getRequestQueue().add(req);
    }

    public void cancelPendingRequests() {
        getRequestQueue().cancelAll(TAG);
    }

    public void changeLocale(Locale locale, AppCompatActivity activity) {
        SharedPreferences preferences = activity.getSharedPreferences(DATABASE_NAME, MODE_PRIVATE);

        if (locale.equals(LOCALE_ENGLISH)) {
            language = LANGUAGE_ENGLISH;
        } else {
            language = LANGUAGE_PORTUGUESE;
        }
        preferences.edit().putString(LOCALE, language).apply();

        Locale.setDefault(locale);
        Resources resources = activity.getResources();
        Configuration config = resources.getConfiguration();
        config.locale = locale;
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
            config.setLayoutDirection(locale);
        }
        resources.updateConfiguration(config, resources.getDisplayMetrics());
    }

    public void resetLocale(AppCompatActivity myActivity) {
        SharedPreferences preferences = myActivity.getSharedPreferences(DATABASE_NAME, MODE_PRIVATE);

        String savedLanguage = preferences.getString(LOCALE, LANGUAGE_ENGLISH);

        if (savedLanguage.equals(language)) {
            return;
        }

        if (savedLanguage.equals(LANGUAGE_ENGLISH)) {
            language = LANGUAGE_ENGLISH;
            language = savedLanguage;
            changeLocale(LOCALE_ENGLISH, myActivity);
        } else {
            language = LANGUAGE_PORTUGUESE;
            language = savedLanguage;
            changeLocale(LOCALE_PORTUGUESE, myActivity);
        }
    }

    public static Locale getChangeToLocale() {
        if (language.equals(LANGUAGE_ENGLISH)) {
            return LOCALE_PORTUGUESE;
        } else {
            return LOCALE_ENGLISH;
        }
    }

    public User getCurrentUser() {
        return this.currentUser;
    }

    public void setCurrentUser(User currentUser) {
        this.currentUser = currentUser;
    }
}
