package com.autotech.we1ldriver.app

import android.content.Context
import android.content.SharedPreferences
import android.preference.PreferenceManager

import com.autotech.we1ldriver.my_classes.User

class We1LPreferences private constructor(context: Context) {
    private val sharedPreferences: SharedPreferences


    var isLoggedIn: Boolean
        get() = sharedPreferences.getBoolean("IS_USER", false)
        set(isLoggedIn) = sharedPreferences.edit().putBoolean("IS_USER", isLoggedIn).apply()

    var user: User
        get() = User(sharedPreferences.getInt("Id", 0),
                sharedPreferences.getString("Name", "")!!,
                sharedPreferences.getString("Tel", "")!!,
                sharedPreferences.getString("Mobile", "")!!,
                sharedPreferences.getString("License", "")!!,
                sharedPreferences.getString("PalletNumber", "")!!,
                sharedPreferences.getBoolean("IsActive", false),
                sharedPreferences.getBoolean("IsShown", false),
                sharedPreferences.getBoolean("IsAndroid", false),
                sharedPreferences.getString("Token", "")!!,
                sharedPreferences.getString("ImageURL", "")!!)
        set(user) {
            sharedPreferences.edit().putInt("Id", user.id).apply()
            sharedPreferences.edit().putString("Name", user.name).apply()
            sharedPreferences.edit().putString("Tel", user.tel).apply()
            sharedPreferences.edit().putString("Mobile", user.mobile).apply()
            sharedPreferences.edit().putString("License", user.license).apply()
            sharedPreferences.edit().putString("PalletNumber", user.palletNumber).apply()
            sharedPreferences.edit().putBoolean("IsActive", user.isActive).apply()
            sharedPreferences.edit().putBoolean("IsShown", user.isShown).apply()
            sharedPreferences.edit().putBoolean("IsAndroid", user.isAndroid).apply()
            sharedPreferences.edit().putString("Token", user.token).apply()
            sharedPreferences.edit().putString("ImageURL", user.imageURL).apply()
        }


    fun clear() {
        this.sharedPreferences.edit().clear().apply()
    }

    init {
        sharedPreferences = PreferenceManager.getDefaultSharedPreferences(context)
    }

    companion object {

        private var preferences: We1LPreferences? = null

        @Synchronized
        fun getPreferences(context: Context): We1LPreferences {

            if (preferences == null) preferences = We1LPreferences(context)

            return preferences as We1LPreferences
        }
    }


}
