package com.autotech.we1ldriver.my_classes;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

public abstract class _MyAdapter<VH extends _MyHolder, ITEM extends _MyItem> extends RecyclerView.Adapter<VH> {

    protected Context context;
    protected _MyList<ITEM> data = new _MyList<>();
    protected OnClickListener<ITEM> onClickListener;
    protected int viewRes = -1;

    public _MyAdapter(Context context, _MyList<ITEM> data) {
        this.context = context;
        this.data.addAll(data);
        this.onClickListener = null;
    }

    public _MyAdapter(Context context, _MyList<ITEM> data, int viewRes) {
        this.context = context;
        this.data.addAll(data);
        this.onClickListener = null;
        this.viewRes = viewRes;
    }

    public _MyAdapter(Context context, _MyList<ITEM> data, OnClickListener<ITEM> onClickListener) {
        this(context, data);
        this.onClickListener = onClickListener;
    }

    public _MyAdapter(Context context, _MyList<ITEM> data, int viewRes, OnClickListener<ITEM> onClickListener) {
        this(context, data);
        this.onClickListener = onClickListener;
        this.viewRes = viewRes;
    }

    public void updateData(_MyList<ITEM> newData) {
        this.data.clear();
        this.data.addAll(newData);
        notifyDataSetChanged();
    }

    public void addItem(ITEM addedItem) {
        this.data.add(0, addedItem);
        notifyItemInserted(0);
    }

    public int getItemCount() {
        return data.size();
    }

    protected View inflate(int resId, ViewGroup parent) {
        return LayoutInflater.from(context).inflate(resId, parent, false);
    }

    public void add(ITEM item) {
        data.add(item);
        notifyItemInserted(data.indexOf(item));
    }

    public void add(int position, ITEM item) {
        data.add(position, item);
        notifyItemInserted(position);
    }

    public void addForceRefresh(int position, ITEM item) {
        data.add(position, item);
        notifyDataSetChanged();
    }

    public void remove(int position) {
        data.remove(position);
        notifyItemRemoved(position);
    }

    public void removeForceRefresh(int position) {
        data.remove(position);
        notifyDataSetChanged();
    }

    public void remove(ITEM item) {
        int position = data.indexOf(item);
        data.remove(item);
        notifyItemRemoved(position);
    }

    public void refresh(int position) {
        notifyItemChanged(position);
    }

    public void clear() {
        data.clear();
        notifyDataSetChanged();
    }

    public void onBindViewHolder(@NonNull VH holder, int position) {
        holder.itemView.setOnClickListener(view -> {
                    if (onClickListener != null)
                        onClickListener.onClick(holder, position, data.get(position));
                }
        );

        holder.itemView.setOnLongClickListener(view -> {
            if (onClickListener != null)
                onClickListener.onLongClick(holder, position, data.get(position));
            return true;
        });
        onBindViewHolderToItem(holder, data.get(position), position);
    }

    public void onBindViewHolderToItem(VH holder, ITEM item, int position) {

    }

    public interface OnClickListener<ITEM extends _MyItem> {

        default void onClick(@NonNull RecyclerView.ViewHolder holder, int position, @NonNull ITEM item) {
        }

        default void onLongClick(@NonNull RecyclerView.ViewHolder holder, int position, @NonNull ITEM item) {
        }

        default void onSpecialClick(@NonNull View view, @NonNull RecyclerView.ViewHolder holder, int position, @NonNull ITEM item) {
        }
    }

}
