package com.autotech.we1ldriver.my_classes;

import android.os.Parcel;
import android.os.Parcelable;

import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.Arrays;

public class _MyList<T extends _MyItem> extends ArrayList<T> implements Parcelable {

    public _MyList(Parcel in) {
        T[] array = (T[]) in.readArray(ClassLoader.getSystemClassLoader());
        this.addAll(Arrays.asList(array));
    }

    public _MyList() {

    }

    public static final Creator<_MyList> CREATOR = new Creator<_MyList>() {
        @Override
        public _MyList createFromParcel(Parcel in) {
            return new _MyList(in);
        }

        @Override
        public _MyList[] newArray(int size) {
            return new _MyList[size];
        }
    };

    @Nullable
    public T findItemById(int id) {
        for (int i = 0; i < size(); i++) {
            if (get(i).getId() == id) {
                return get(i);
            }
        }
        return null;
    }



    public _MyList<T> searchByName(String name) {
        _MyList<T> newList = new _MyList<>();
        for (int i = 0; i < size(); i++) {
            if (get(i).getName().toLowerCase().trim().contains(name.toLowerCase().trim())) {
                newList.add(get(i));
            }
        }
        return newList;
    }


    public ArrayList<String> getNames() {
        ArrayList<String> names = new ArrayList<>();
        for (int i = 0; i < size(); i++) {
            names.add(get(i).getName());
        }
        return names;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int i) {
        out.writeParcelableArray(toArray(new Parcelable[size()]), 0);
    }
}
