package com.autotech.we1ldriver.service

import android.app.NotificationChannel
import android.app.NotificationManager
import android.app.PendingIntent
import android.content.Context
import android.content.Intent
import android.media.RingtoneManager
import android.os.Build
import android.support.v4.app.NotificationCompat
import android.support.v4.content.ContextCompat
import com.autotech.we1ldriver.R
import com.autotech.we1ldriver.app.We1LPreferences
import com.autotech.we1ldriver.tools.ATTR_SYSTEM_PASSCODE
import com.autotech.we1ldriver.tools.REQUEST_TOKEN
import com.autotech.we1ldriver.tools.SYSTEM_PASSCODE
import com.autotech.we1ldriver.view.activities.MainActivity
import com.autotech.we1ldriver.volley.IVolleyRequest
import com.autotech.we1ldriver.volley.VolleyRequest
import com.google.firebase.messaging.FirebaseMessagingService
import com.google.firebase.messaging.RemoteMessage
import org.json.JSONObject
import java.util.concurrent.atomic.AtomicInteger

class FCMService : FirebaseMessagingService() {


    override fun onNewToken(token: String?) {
        super.onNewToken(token)

        val mapToken = HashMap<String, String>()
        mapToken[ATTR_SYSTEM_PASSCODE] = SYSTEM_PASSCODE
        mapToken["Driver"] = We1LPreferences.getPreferences(applicationContext).user.id.toString()
        mapToken["Token"] = token!!

        VolleyRequest.getVolleyRequest().post(REQUEST_TOKEN, mapToken, object : IVolleyRequest {
            override fun onFail(response: JSONObject?) {}
            override fun onSuccess(response: JSONObject?) {}
            override fun getResponse(response: JSONObject?, message: String?, resultCode: Int) {}
        })
    }

    override fun onMessageReceived(remoteMessage: RemoteMessage?) {
        super.onMessageReceived(remoteMessage)

        val intent = Intent(this, MainActivity::class.java)
        intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP)
        val pendingIntent = PendingIntent.getActivity(this, 0, intent, PendingIntent.FLAG_ONE_SHOT)

        val channelId = getString(R.string.default_notification_channel_id)
        val defaultSoundUri = RingtoneManager.getDefaultUri(RingtoneManager.TYPE_NOTIFICATION)

        val notificationBuilder = NotificationCompat.Builder(this, channelId)
                .setSmallIcon(R.drawable.ic_stat_ic_notification)
                .setContentTitle(remoteMessage?.notification?.title)
                .setContentText(remoteMessage?.notification?.body)
                .setSubText(applicationContext.getString(R.string.app_name))
                .setShowWhen(false)
                .setAutoCancel(true)
                .setStyle(NotificationCompat.BigTextStyle().bigText(remoteMessage?.notification?.body))
                .setColor(ContextCompat.getColor(applicationContext, R.color.colorAccent))
                .setSound(defaultSoundUri)
                .setContentIntent(pendingIntent)

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N)
            notificationBuilder.priority = NotificationManager.IMPORTANCE_DEFAULT

        val notificationManager = getSystemService(Context.NOTIFICATION_SERVICE) as NotificationManager

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            val channel = NotificationChannel(channelId, getString(R.string.app_name), NotificationManager.IMPORTANCE_DEFAULT)
            channel.enableLights(true)
            channel.lightColor = ContextCompat.getColor(applicationContext, R.color.colorAccent)
            channel.enableVibration(true)
            notificationManager.createNotificationChannel(channel)
        } else
            notificationBuilder.setLights(ContextCompat.getColor(applicationContext, R.color.colorAccent), 1024, 1024)

        val notificationId: Int = AtomicInteger(0).incrementAndGet()

        notificationManager.notify(notificationId, notificationBuilder.build())
    }
}
