package com.autotech.we1ldriver.tools

import android.content.Context
import android.support.v4.content.ContextCompat
import android.support.v4.widget.CircularProgressDrawable
import android.widget.ImageView
import com.squareup.picasso.Callback
import com.squareup.picasso.MemoryPolicy
import com.squareup.picasso.Picasso
import java.lang.Exception

class PicassoUtils {

    fun getImage(imgUrl: String, context: Context, imageView: ImageView, drawable: Int) {
        Picasso.get()
                .load(imgUrl)
                .fit()
                .centerCrop()
                .placeholder(buildCircularProgressDrawable(context))
                .into(imageView, object : Callback {

                    override fun onError(e: Exception?) {
                        imageView.setImageDrawable(ContextCompat.getDrawable(context, drawable))
                    }

                    override fun onSuccess() {
                        TODO("not implemented") //To change body of created functions use File | Settings | File Templates.
                    }
                })
    }

    private fun buildCircularProgressDrawable(context: Context): CircularProgressDrawable {
        val drawable = CircularProgressDrawable(context)
        drawable.strokeWidth = 5.0f
        drawable.centerRadius = 36.0f
        drawable.start()

        return drawable
    }
}