package com.autotech.we1ldriver.tools

import android.content.Context
import android.content.Intent
import android.net.ConnectivityManager
import android.net.NetworkInfo
import com.autotech.we1ldriver.view.activities.InvoiceDetailsActivity
import com.autotech.we1ldriver.view.activities.MainActivity
import com.autotech.we1ldriver.view.activities.ProfileActivity
import com.autotech.we1ldriver.my_classes.Invoice
import com.autotech.we1ldriver.my_classes._MyActivity

fun launchMainActivity(context: Context) {
    context.startActivity(Intent(context, MainActivity::class.java).addFlags(Intent.FLAG_ACTIVITY_NEW_TASK))
}

fun launchProfile(activity: _MyActivity) = activity.startActivity(Intent(activity, ProfileActivity::class.java))

fun launchInvoiceDetails(activity: _MyActivity, invoice: Invoice) = activity.startActivity(Intent(activity, InvoiceDetailsActivity::class.java).putExtra(ATTR_INVOICE, invoice))


fun isNetworkAvailable(context: Context): Boolean {
    val connectivityManager = context.getSystemService(Context.CONNECTIVITY_SERVICE) as ConnectivityManager
    val activeNetworkInfo: NetworkInfo? = connectivityManager.activeNetworkInfo
    return activeNetworkInfo != null && activeNetworkInfo.isConnected
}