package com.autotech.we1ldriver.view.activities

import android.annotation.SuppressLint
import android.os.Bundle
import android.support.v7.widget.LinearLayoutManager
import android.view.MenuItem
import android.view.View
import android.view.animation.AnimationUtils
import android.widget.Toast
import com.autotech.we1ldriver.R
import com.autotech.we1ldriver.adapters.InvoiceDetailsAdapter
import com.autotech.we1ldriver.my_classes.Invoice
import com.autotech.we1ldriver.my_classes.InvoiceDetails
import com.autotech.we1ldriver.my_classes._MyActivity
import com.autotech.we1ldriver.tools.ATTR_INVOICE
import com.google.android.gms.maps.CameraUpdateFactory
import com.google.android.gms.maps.GoogleMap
import com.google.android.gms.maps.OnMapReadyCallback
import com.google.android.gms.maps.SupportMapFragment
import com.google.android.gms.maps.model.LatLng
import kotlinx.android.synthetic.main.activity_order_details.*
import android.view.ViewGroup
import android.widget.LinearLayout
import com.google.android.gms.maps.model.MarkerOptions
import java.lang.Exception

class InvoiceDetailsActivity : _MyActivity(), OnMapReadyCallback {


    private var invoice: Invoice? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        setContentView(R.layout.activity_order_details)

        invoice = intent.extras.getSerializable(ATTR_INVOICE) as Invoice

        setSupportActionBar(toolbar)
        supportActionBar?.title = getString(R.string.order, invoice?.OrderNumber)

        calculateQtyAndTotalPrice()

        supportActionBar?.setDisplayHomeAsUpEnabled(true)
        supportActionBar?.setDisplayShowHomeEnabled(true)

        doAll()

        createViewOfInvoiceDetails(invoiceDetails = invoice?.InvoiceDetails)
    }

    @SuppressLint("SetTextI18n")
    override fun setupViews() {

        recyclerView.layoutManager = LinearLayoutManager(applicationContext)
        recyclerView.setHasFixedSize(true)

        toolbar.setNavigationOnClickListener { onBackPressed() }

        val display = windowManager.defaultDisplay
        val height = display.height
        val params = LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT)
        params.height = height / 3

        val mapFragment = supportFragmentManager.findFragmentById(R.id.map) as SupportMapFragment

        if (invoice?.Lat == "null" || invoice?.Lon == "null") {
            mapFragment.view?.visibility = View.GONE
        } else {
            mapFragment.view?.layoutParams = params
            mapFragment.getMapAsync(this)
        }
    }

    override fun setupClickListeners() {

    }

    override fun onMapReady(googleMap: GoogleMap) {
        try {
            val customerLongLat = LatLng(invoice?.Lat!!.toDouble(), invoice?.Lon!!.toDouble())
            googleMap.addMarker(MarkerOptions().position(customerLongLat))
            googleMap.moveCamera(CameraUpdateFactory.newLatLngZoom(customerLongLat, 12f))
            googleMap.mapType = GoogleMap.MAP_TYPE_HYBRID
        } catch (e: Exception) {
        }
    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        when (item.itemId) {
            R.id.home -> {
                onBackPressed()
            }
            else -> {
            }
        }
        return super.onOptionsItemSelected(item)
    }

    private fun calculateQtyAndTotalPrice() {

        var qty = 0
        var price = 0

        for (i in 0 until invoice?.InvoiceDetails!!.size) {
            qty += invoice?.InvoiceDetails?.get(i)?.QTY?.toInt()!!
            price += invoice?.InvoiceDetails?.get(i)?.Product?.Price?.toDouble()?.toInt()!!
        }

        textViewQty.text = getString(R.string.total_quantity, qty.toString())
        textViewTotalPrice.text = getString(R.string.total_price, price.toString())
        textViewStatus.text = getString(R.string.status, invoice?.Status)
        textViewAddress.text = getString(R.string.address, invoice?.Address)

        val animation = AnimationUtils.loadAnimation(applicationContext, android.R.anim.fade_in)
        textViewQty.startAnimation(animation)
        textViewTotalPrice.startAnimation(animation)
        textViewStatus.startAnimation(animation)
        textViewAddress.startAnimation(animation)
    }


    private fun createViewOfInvoiceDetails(invoiceDetails: ArrayList<InvoiceDetails>?) {

        if (invoiceDetails?.isEmpty()!!) {
            Toast.makeText(applicationContext, R.string.has_no_products, Toast.LENGTH_SHORT).show()
            return
        }

        val invoiceDetailsAdapter = InvoiceDetailsAdapter(invoiceDetails, onClickInvoiceDetails = object : InvoiceDetailsAdapter.OnClickInvoiceDetails {

            override fun onClick(invoiceDetails: InvoiceDetails) {
            }
        })

        recyclerView.adapter = invoiceDetailsAdapter
    }

}
