package com.autotech.we1ldriver.view.activities

import android.os.Bundle
import android.view.View
import android.view.Window
import android.view.WindowManager
import android.widget.Toast
import com.autotech.we1ldriver.R
import com.autotech.we1ldriver.app.MyApp
import com.autotech.we1ldriver.app.We1LPreferences
import com.autotech.we1ldriver.my_classes.User
import com.autotech.we1ldriver.my_classes._MyActivity
import com.autotech.we1ldriver.tools.*
import com.autotech.we1ldriver.volley.IVolleyRequest
import com.autotech.we1ldriver.volley.VolleyRequest

import kotlinx.android.synthetic.main.activity_log_in.*
import org.json.JSONObject

class LogInActivity : _MyActivity(), IVolleyRequest {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        if (We1LPreferences.getPreferences(applicationContext).isLoggedIn) {
            launchMainActivity(applicationContext)
            return
        }

        requestWindowFeature(Window.FEATURE_NO_TITLE)

        window.setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN, WindowManager.LayoutParams.FLAG_FULLSCREEN)

        setContentView(R.layout.activity_log_in)

        doAll()
    }

    override fun onResume() {
        super.onResume()
        if (We1LPreferences.getPreferences(applicationContext).isLoggedIn) {
            launchMainActivity(applicationContext)
            return
        }
    }

    override fun setupViews() {

    }

    override fun setupClickListeners() {
        log_in.setOnClickListener {

            if (username.text.toString().trim().isEmpty() || password.text.toString().trim().isEmpty()) {

                Toast.makeText(applicationContext, getString(R.string.some_fields_are_empty), Toast.LENGTH_LONG).show()

                return@setOnClickListener
            }

            if (password.text.toString().length < 6) {
                Toast.makeText(applicationContext, getString(R.string.password_length), Toast.LENGTH_LONG).show()
                return@setOnClickListener
            }

            if (!isNetworkAvailable(applicationContext)) {
                Toast.makeText(applicationContext, getString(R.string.no_net), Toast.LENGTH_LONG).show()
                return@setOnClickListener
            }


            progressBar.visibility = View.VISIBLE
            textInputLayoutUsername.visibility = View.INVISIBLE
            textInputLayoutPassword.visibility = View.INVISIBLE
            log_in.visibility = View.INVISIBLE

            val mapLogin = HashMap<String, String>()
            mapLogin[ATTR_SYSTEM_PASSCODE] = SYSTEM_PASSCODE
            mapLogin[ATTR_USERNAME] = username.text.toString().trim()
            mapLogin[ATTR_PASSWORD] = password.text.toString().trim()

            VolleyRequest.getVolleyRequest().post(REQUEST_LOG_IN, mapLogin, this)

        }
    }

    override fun getResponse(response: JSONObject?, message: String?, resultCode: Int) {
        when (response?.getInt(ATTR_ERROR_CODE)) {

            CODE_OK -> {

                val json = response.getJSONObject(ATTR_DATA).getJSONObject(ATTR_DATA) as JSONObject

                val user = User(json.getInt("ID"), json.getString("Name"), json.getString("Tel"),
                        json.getString("Mobile"), json.getString("License"), json.getString("PalletNumber"),
                        json.getBoolean("IsActive"), json.getBoolean("IsShown"), json.getBoolean("IsAndroid"),
                        json.getString("Token"), json.getString("ImageURL"))

                MyApp.getInstance().currentUser = user

                We1LPreferences.getPreferences(applicationContext).user = user
                We1LPreferences.getPreferences(applicationContext).isLoggedIn = true
                launchMainActivity(applicationContext)
                finish()
            }

            else ->
                Toast.makeText(applicationContext, getString(R.string.user_pass_error), Toast.LENGTH_LONG).show()

        }
    }

    override fun onSuccess(response: JSONObject?) {
        showViews()
    }

    override fun onFail(response: JSONObject?) {
        showViews()
    }

    private fun showViews() {
        progressBar.visibility = View.GONE
        textInputLayoutUsername.visibility = View.VISIBLE
        textInputLayoutPassword.visibility = View.VISIBLE
        log_in.visibility = View.VISIBLE
    }

}
