package com.autotech.we1ldriver.view.activities

import android.app.ProgressDialog
import android.content.Intent
import android.os.Bundle
import android.support.v7.app.AlertDialog
import android.view.Menu
import android.view.MenuItem
import android.view.View
import android.widget.Toast
import com.autotech.we1ldriver.R
import com.autotech.we1ldriver.adapters.InvoicesAdapter
import com.autotech.we1ldriver.app.We1LPreferences
import com.autotech.we1ldriver.my_classes.*
import com.autotech.we1ldriver.tools.*
import com.autotech.we1ldriver.volley.IVolleyRequest
import com.autotech.we1ldriver.volley.VolleyRequest
import com.autotech.we1ldriver.volley.VolleyRequest.Companion.RESULT_FAILED
import com.autotech.we1ldriver.volley.VolleyRequest.Companion.RESULT_SUCCESS
import com.google.android.gms.tasks.OnCompleteListener
import com.google.firebase.iid.FirebaseInstanceId
import com.google.firebase.iid.InstanceIdResult
import kotlinx.android.synthetic.main.activity_main.*
import org.json.JSONArray
import org.json.JSONObject
import android.app.SearchManager
import android.content.Context
import android.graphics.Color
import android.os.Build
import android.support.v7.widget.*
import android.util.Log
import android.view.animation.AnimationUtils
import com.autotech.we1ldriver.R.id.swipeRefreshLayout
import com.autotech.we1ldriver.view.bottomViewFragment.StatusFragment


class MainActivity : _MyActivity(), IDoneChangeStatus {

    override fun onChangeCompleted() {
        getOrder()
    }

    private var invoicesAdapter: InvoicesAdapter? = null
    private var searchView: SearchView? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)
        setSupportActionBar(toolbar_main)

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            toolbar_main.elevation = 8f
        }

        doAll()

        sendFcmToken()
        getOrder()
        whiteNotificationBar(invoices_rv)
    }

    private fun sendFcmToken() {
        FirebaseInstanceId.getInstance().instanceId.addOnCompleteListener(OnCompleteListener<InstanceIdResult> { task ->
            if (!task.isSuccessful) return@OnCompleteListener

            val token = task.result?.token as String

            Log.e("token", token);

            val mapToken = HashMap<String, String>()
            mapToken[ATTR_SYSTEM_PASSCODE] = SYSTEM_PASSCODE
            mapToken["Driver"] = We1LPreferences.getPreferences(applicationContext).user.id.toString()
            mapToken["Token"] = token

            VolleyRequest.getVolleyRequest().post(REQUEST_TOKEN, mapToken, object : IVolleyRequest {
                override fun onFail(response: JSONObject?) {}
                override fun onSuccess(response: JSONObject?) {}
                override fun getResponse(response: JSONObject?, message: String?, resultCode: Int) {}
            })
        })

    }

    private fun hideLoader() {
        progressBar.visibility = View.GONE
        swipeRefreshLayout.isRefreshing = false
    }

    private fun getOrder() {
        if (!isNetworkAvailable(applicationContext)) {
            Toast.makeText(applicationContext, "No Internet connection", Toast.LENGTH_SHORT).show()
            return
        }

        val mapOrder = HashMap<String, String>()
        mapOrder[ATTR_SYSTEM_PASSCODE] = SYSTEM_PASSCODE
        mapOrder["Driver"] = We1LPreferences.getPreferences(applicationContext).user.id.toString()

        VolleyRequest.getVolleyRequest().post(REQUEST_ORDERS, mapOrder, object : IVolleyRequest {
            override fun onFail(response: JSONObject?) {
                hideLoader()
            }

            override fun onSuccess(response: JSONObject?) {
                hideLoader()
            }

            override fun getResponse(response: JSONObject?, message: String?, resultCode: Int) {
                hideLoader()

                when (resultCode) {
                    RESULT_SUCCESS -> {
                        if (response?.getInt(ATTR_ERROR_CODE) != CODE_OK) {
                            Toast.makeText(applicationContext, response?.getString(ATTR_ERROR_MESSAGE), Toast.LENGTH_SHORT).show()
                            return
                        }
                        try {
                            val data = response.getJSONObject(ATTR_DATA).getJSONArray(ATTR_DATA) as JSONArray

                            if (data.length() == 0) {
                                Toast.makeText(applicationContext, "Have a good day , you don't have order today.", Toast.LENGTH_SHORT).show()
                                createView(ArrayList<Invoice>())
                                return
                            }

                            val order = ArrayList<Invoice>()

                            for (i in 0..(data.length() - 1)) {

                                val jsonData = data.get(i) as JSONObject

                                val invoice = Invoice(jsonData.getInt("ID"), jsonData.getString("OrderNumber"),
                                        jsonData.getString("AWBNumber"), jsonData.getString("AddDateTime"),
                                        jsonData.getString("Status"), jsonData.getString("Address"),
                                        jsonData.getString("Lat"), jsonData.getString("Lon"), ArrayList())

                                val jsonArrayInvoiceDetails = jsonData.getJSONArray("InvoiceDetails") as JSONArray

                                if (jsonArrayInvoiceDetails.length() != 0) {

                                    for (j in 0..(jsonArrayInvoiceDetails.length() - 1)) {

                                        val jsonInvoiceDetails = jsonArrayInvoiceDetails.getJSONObject(j) as JSONObject

                                        val invoiceDetails = InvoiceDetails(jsonInvoiceDetails.getString("QTY"), null)

                                        val jsonObjectProduct = jsonInvoiceDetails.getJSONObject("Product") as JSONObject

                                        val product = Product(jsonObjectProduct.getInt("ID"),
                                                jsonObjectProduct.getString("Name"),
                                                jsonObjectProduct.getString("Price"),
                                                jsonObjectProduct.getString("AddDateTime"),
                                                jsonObjectProduct.getString("ReturnPolicyText"))

//                                        val jsonObjectImages = jsonObjectProduct.getJSONObject("Images") as JSONObject
//
//                                      val images = Images(ArrayList(), ArrayList())
//
//                                        val listOfNoColor = ArrayList<String>()
//
//                                        val jsonArrayNoColor = jsonObjectImages.getJSONArray("NoColor") as JSONArray
//
//                                        if (jsonArrayNoColor.length() != 0)
//                                            for (k in 0..(jsonArrayNoColor.length() - 1)) {
//                                                listOfNoColor.add(jsonArrayNoColor.get(i) as String)
//                                            }
//                                        images.noColorList = listOfNoColor
//
//
//                                        val jsonArrayColor = jsonObjectImages.getJSONArray("Color") as JSONArray
//
//                                        val itemColorList = ArrayList<ItemColor>()
//
//                                        if (jsonArrayColor.length() != 0)
//                                            for (l in 0..(jsonArrayColor.length() - 1)) {
//                                                val jsonObjectItemColor = jsonArrayColor.getJSONObject(l) as JSONObject
//
//                                                val itemColor = ItemColor(jsonObjectItemColor.getInt("ColorID"),
//                                                        jsonObjectItemColor.getString("ColorURL"), ArrayList())
//
//                                                val productImageColor = ArrayList<String>()
//
//                                                val jsonArrayProductImages = jsonObjectItemColor.getJSONArray("ProductImages") as JSONArray
//                                                if (jsonArrayProductImages.length() != 0)
//                                                    for (m in 0..(jsonArrayProductImages.length() - 1)) {
//                                                        productImageColor.add(jsonArrayProductImages.get(m) as String)
//                                                    }
//                                                itemColor.productImages = productImageColor
//
//                                                itemColorList.add(itemColor)
//                                            }

                                        //images.colorList = itemColorList

                                        invoiceDetails.Product = product
                                        invoice.InvoiceDetails?.add(invoiceDetails)
                                    }

                                }

                                order.add(invoice)
                            }
                            createView(order)
                        } catch (e: Exception) {
                            Log.e("eeeEEE", e.message)
                        }
                    }

                    RESULT_FAILED -> Toast.makeText(applicationContext, message, Toast.LENGTH_SHORT).show()
                }
            }
        })
    }

    private fun createView(invoices: List<Invoice>) {

        if (invoices.isEmpty()) {
            if (imageView.visibility != View.VISIBLE && textView.visibility != View.VISIBLE) {
                imageView.visibility = View.VISIBLE
                textView.visibility = View.VISIBLE
                imageView.startAnimation(AnimationUtils.loadAnimation(applicationContext, android.R.anim.fade_in))
                textView.startAnimation(AnimationUtils.loadAnimation(applicationContext, android.R.anim.fade_in))
            }
        } else {
            if (imageView.visibility == View.VISIBLE && textView.visibility == View.VISIBLE) {
                imageView.visibility = View.GONE
                textView.visibility = View.GONE
                imageView.startAnimation(AnimationUtils.loadAnimation(applicationContext, android.R.anim.fade_out))
                textView.startAnimation(AnimationUtils.loadAnimation(applicationContext, android.R.anim.fade_out))
            }
        }

        invoicesAdapter = InvoicesAdapter(invoices, object : InvoicesAdapter.OnClickListener {
            override fun onClick(holder: RecyclerView.ViewHolder, position: Int, item: Invoice) {
                launchInvoiceDetails(this@MainActivity, item)
            }

            override fun onSpecialClick(view: View, holder: RecyclerView.ViewHolder, position: Int, item: Invoice) {
                when (view.id) {
                    R.id.change_status -> {

                        val bundle = Bundle()
                        bundle.putSerializable("Invoice", item)

                        val fragment = StatusFragment()

                        fragment.arguments = bundle

                        supportFragmentManager.beginTransaction()
                                .add(fragment, fragment::class.java.name)
                                .commitNow()

                    }
                }
            }
        })

        invoices_rv.adapter = invoicesAdapter

    }

    override fun setupViews() {
        invoices_rv.setHasFixedSize(true)
        invoices_rv.layoutManager = LinearLayoutManager(applicationContext)
        invoices_rv.itemAnimator = DefaultItemAnimator()

        swipeRefreshLayout.setColorScheme(R.color.colorAccent)
        swipeRefreshLayout.setOnRefreshListener { getOrder() }

        imageView.visibility = View.GONE
        textView.visibility = View.GONE
    }

    override fun setupClickListeners() {

    }

    private fun doLogOut() {
        AlertDialog.Builder(this)
                .setMessage("Are you sure to log out ?")
                .setNegativeButton("No") { dialog, _ ->
                    dialog.dismiss()
                }
                .setPositiveButton("Yes") { dialog, _ ->
                    run {

                        dialog.dismiss()

                        val progressDialog = ProgressDialog(this@MainActivity)
                        progressDialog.setMessage("Please wait ...")

                        progressDialog.show()

                        val mapLogOut = HashMap<String, String>()

                        mapLogOut[ATTR_SYSTEM_PASSCODE] = SYSTEM_PASSCODE
                        mapLogOut["Driver"] = We1LPreferences.getPreferences(applicationContext).user.id.toString()

                        VolleyRequest.getVolleyRequest().post(REQUEST_LOG_OUT, mapLogOut, object : IVolleyRequest {
                            override fun onSuccess(response: JSONObject?) {
                                progressDialog.dismiss()
                            }

                            override fun getResponse(response: JSONObject?, message: String?, resultCode: Int) {
                                progressDialog.dismiss()

                                when (resultCode) {
                                    VolleyRequest.RESULT_SUCCESS -> {

                                        if (response?.getInt(ATTR_ERROR_CODE) != CODE_OK) {

                                            Toast.makeText(applicationContext, response?.getString(ATTR_ERROR_MESSAGE), Toast.LENGTH_SHORT).show()
                                            return
                                        }

                                        We1LPreferences.getPreferences(applicationContext).clear()
                                        val intent = Intent(applicationContext, LogInActivity::class.java)

                                        startActivity(intent)

                                    }

                                    VolleyRequest.RESULT_FAILED -> {
                                        Toast.makeText(applicationContext, response?.getString(ATTR_ERROR_MESSAGE), Toast.LENGTH_SHORT).show()
                                    }
                                }

                            }

                            override fun onFail(response: JSONObject?) {
                                progressDialog.dismiss()
                            }
                        })
                    }
                }
                .create()
                .show()
    }

    private fun whiteNotificationBar(view: View) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            var flags = view.systemUiVisibility
            flags = flags or View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR
            view.systemUiVisibility = flags
            window.statusBarColor = Color.WHITE
        }
    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        when (item.itemId) {

            R.id.profile -> {
                launchProfile(this)
            }
            R.id.action_search -> {
                return true
            }

            R.id.log_out -> {
                doLogOut()
            }

            else -> {
            }
        }
        return super.onOptionsItemSelected(item)
    }

    override fun onCreateOptionsMenu(menu: Menu): Boolean {
        menuInflater.inflate(R.menu.menu_main, menu)

        val searchManager = getSystemService(Context.SEARCH_SERVICE) as SearchManager
        searchView = menu.findItem(R.id.action_search).actionView as SearchView
        searchView?.setSearchableInfo(searchManager.getSearchableInfo(componentName))
        searchView?.maxWidth = Integer.MAX_VALUE

        searchView?.setOnQueryTextListener(object : SearchView.OnQueryTextListener {
            override fun onQueryTextChange(query: String?): Boolean {
                invoicesAdapter?.filter?.filter(query)
                return false
            }

            override fun onQueryTextSubmit(query: String?): Boolean {
                invoicesAdapter?.filter?.filter(query)
                return false
            }
        })

        val menuItem = menu.findItem(R.id.action_search)
        menuItem.setOnActionExpandListener(object : MenuItem.OnActionExpandListener {
            override fun onMenuItemActionCollapse(item: MenuItem?): Boolean {
                return true
            }

            override fun onMenuItemActionExpand(item: MenuItem?): Boolean {
                return true
            }
        })

        return true
    }

    override fun onBackPressed() {
        super.onBackPressed()

        if (!searchView?.isIconified!!) {
            searchView?.isIconified = true
            return
        }

        moveTaskToBack(true)
    }
}