package com.autotech.we1ldriver.view.activities

import android.os.Bundle
import android.support.v7.app.AppCompatActivity
import com.autotech.we1ldriver.R
import com.autotech.we1ldriver.app.We1LPreferences
import com.autotech.we1ldriver.my_classes.User
import com.autotech.we1ldriver.tools.PicassoUtils

import kotlinx.android.synthetic.main.activity_profile.*

class ProfileActivity : AppCompatActivity() {


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_profile)

        val user: User = We1LPreferences.getPreferences(applicationContext).user

        textViewName.text = user.name
        textViewMobile.text = getString(R.string.mobile, user.mobile)
        textViewTel.text = getString(R.string.tel, user.tel)
        textViewLicense.text = getString(R.string.license, user.license)
        textViewPalletNumber.text = getString(R.string.pallet_number, user.palletNumber)

        PicassoUtils().getImage(user.imageURL, applicationContext, imageViewProfile, R.drawable.app_logo)
    }

}
