package com.autotech.we1ldriver.view.bottomViewFragment

import android.content.Context
import android.content.DialogInterface
import android.graphics.Paint
import android.os.Bundle
import android.os.Handler
import android.support.design.button.MaterialButton
import android.support.design.widget.BottomSheetDialogFragment
import android.support.v7.widget.LinearLayoutManager
import android.support.v7.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Button
import android.widget.TextView
import android.widget.Toast

import com.autotech.we1ldriver.R
import com.autotech.we1ldriver.adapters.StatusAdapter
import com.autotech.we1ldriver.app.We1LPreferences
import com.autotech.we1ldriver.my_classes.IDoneChangeStatus
import com.autotech.we1ldriver.my_classes.IStatus
import com.autotech.we1ldriver.my_classes.Invoice
import com.autotech.we1ldriver.my_classes.Status
import com.autotech.we1ldriver.tools.*
import com.autotech.we1ldriver.volley.IVolleyRequest
import com.autotech.we1ldriver.volley.VolleyRequest

import org.json.JSONException
import org.json.JSONObject

import java.text.ParseException
import java.util.ArrayList
import java.util.HashMap

import com.autotech.we1ldriver.volley.VolleyRequest.Companion.RESULT_SUCCESS

class StatusFragment : BottomSheetDialogFragment(), IStatus {

    private var textViewOrderNumber: TextView? = null
//    private var set_finished: MaterialButton? = null
    private var change_status: MaterialButton? = null
    private var recyclerView: RecyclerView? = null
    private var statusAdapter: StatusAdapter? = null
    private var invoice: Invoice? = null
    private var iDoneChangeStatus: IDoneChangeStatus? = null
    private var status: Status? = null

    override fun onAttach(context: Context?) {
        super.onAttach(context)
        try {
            iDoneChangeStatus = context as IDoneChangeStatus?
        } catch (e: ClassCastException) {
        }

    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        if (arguments == null) dismiss()

        invoice = arguments!!.getSerializable("Invoice") as Invoice
    }

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        return inflater.inflate(R.layout.fragment_status, container, false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        textViewOrderNumber = view.findViewById(R.id.textViewOrderNumber)
//        set_finished = view.findViewById(R.id.set_finished)
        change_status = view.findViewById(R.id.change_status)
        recyclerView = view.findViewById(R.id.recyclerView)

        textViewOrderNumber!!.text = getString(R.string.order, invoice!!.OrderNumber)
        textViewOrderNumber!!.paintFlags = Paint.UNDERLINE_TEXT_FLAG

//        set_finished!!.visibility = View.GONE
    }

    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)

        recyclerView!!.setHasFixedSize(true)
        recyclerView!!.layoutManager = LinearLayoutManager(activity)

        change_status!!.setOnClickListener { changeStatus() }
//        set_finished!!.setOnClickListener { changeStatusToFinished() }

        setStatusEnabled()
    }

    private fun setStatusEnabled() {
        val status3 = Status("shipping", "shipping", true, false)
        val status4 = Status("delivered", "delivered", true, false)
        val status5 = Status("not-delivered", "not delivered", true, false)

        val statusList = ArrayList<Status>()

        statusList.add(status3)
        statusList.add(status4)
        statusList.add(status5)

        if (invoice!!.Status!!.toLowerCase() == "delivered" || invoice!!.Status!!.toLowerCase() == "not delivered") {
            statusList[0].isEnabled = false
            statusList[0].isSelected = false
        } else {
            statusList[0].isEnabled = true
            statusList[0].isSelected = true
        }

        if (invoice!!.Status!!.toLowerCase() == "delivered") {
            statusList[1].isSelected = true
        }
        if (invoice!!.Status!!.toLowerCase() == "not delivered") {
            statusList[2].isSelected = true
        }



        statusAdapter = StatusAdapter(statusList, this)
        recyclerView!!.adapter = statusAdapter
    }

//    private fun changeStatusToFinished() {
//        Toast.makeText(context, "Please wait ...", Toast.LENGTH_SHORT).show()
//
//        val mapChange = HashMap<String, String>()
//        mapChange[ATTR_SYSTEM_PASSCODE] = SYSTEM_PASSCODE
//        mapChange["Invoice"] = Integer.toString(invoice!!.ID)
//        mapChange["Driver"] = Integer.toString(We1LPreferences.getPreferences(activity!!).user.id)
//
//        VolleyRequest.getVolleyRequest().post(REQ_setFinish, mapChange, object : IVolleyRequest {
//            @Throws(JSONException::class)
//            override fun getResponse(response: JSONObject?, message: String?, resultCode: Int) {
//                if (resultCode == RESULT_SUCCESS) {
//                    if (response!!.getInt(ATTR_ERROR_CODE) != CODE_OK) {
//                        Toast.makeText(context, response.getString(ATTR_ERROR_MESSAGE), Toast.LENGTH_SHORT).show()
//                        return
//                    }
//                    Toast.makeText(context, "Status set finished successfully", Toast.LENGTH_SHORT).show()
//
//                    Handler().postDelayed({ dismissAllowingStateLoss() }, 10240)
//
//                } else
//                    Toast.makeText(context, message, Toast.LENGTH_SHORT).show()
//            }
//
//            override fun onSuccess(response: JSONObject?) {}
//
//            override fun onFail(response: JSONObject?) {}
//        })
//    }

    private fun changeStatus() {

        if (!isNetworkAvailable(context!!)) {
            Toast.makeText(context, "No Internet connection", Toast.LENGTH_SHORT).show()
            return
        }

        if (this.status == null) {
            Toast.makeText(context, "Please select status ...", Toast.LENGTH_SHORT).show()
            return
        }

        Toast.makeText(context, "Please wait ...", Toast.LENGTH_SHORT).show()

        change_status?.isEnabled = false

        val mapChange = HashMap<String, String>()
        mapChange[ATTR_SYSTEM_PASSCODE] = SYSTEM_PASSCODE
        mapChange["Invoice"] = Integer.toString(invoice!!.ID)
        mapChange["Status"] = invoice!!.Status!!
        mapChange["Driver"] = Integer.toString(We1LPreferences.getPreferences(activity!!).user.id)

        VolleyRequest.getVolleyRequest().post(REQ_changestatus, mapChange, object : IVolleyRequest {
            @Throws(JSONException::class)
            override fun getResponse(response: JSONObject?, message: String?, resultCode: Int) {

                change_status?.isEnabled = true

                if (resultCode == RESULT_SUCCESS) {
                    if (response!!.getInt(ATTR_ERROR_CODE) != CODE_OK) {
                        Toast.makeText(context, response.getString(ATTR_ERROR_MESSAGE), Toast.LENGTH_SHORT).show()
                        return
                    }
                    Toast.makeText(context, "Status changed successfully", Toast.LENGTH_SHORT).show()

                    Handler().postDelayed({ dismissAllowingStateLoss() }, 128)

                } else
                    Toast.makeText(context, message, Toast.LENGTH_SHORT).show()
            }

            override fun onSuccess(response: JSONObject?) {}

            override fun onFail(response: JSONObject?) {}
        })
    }

    override fun onClick(status: Status) {
        this.status = status

//        if (status.value == "delivered")
//            set_finished!!.visibility = View.VISIBLE
//        else
//            set_finished!!.visibility = View.GONE

        invoice!!.Status = status.value
    }

    override fun onDismiss(dialog: DialogInterface?) {
        super.onDismiss(dialog)
        invoice = null
        statusAdapter = null
        iDoneChangeStatus!!.onChangeCompleted()
    }
}
