package com.autotech.we1ldriver.volley

import android.util.Log

import com.android.volley.DefaultRetryPolicy
import com.android.volley.Request
import com.android.volley.toolbox.StringRequest
import com.autotech.we1ldriver.app.MyApp

import org.json.JSONException
import org.json.JSONObject

import java.text.ParseException

class VolleyRequest private constructor() {

    fun post(URL: String, map: Map<String, String>, iVolleyRequest: IVolleyRequest) {

        if (URL.isEmpty()) return

        Log.e(URL, map.toString())

        val stringRequest = object : StringRequest(Request.Method.POST, URL, { response ->

            Log.e("response:onSuccess", response)
            try {
                iVolleyRequest.getResponse(JSONObject(response), null, RESULT_SUCCESS)
                iVolleyRequest.onSuccess(JSONObject(response))
            } catch (e: Exception) {
            }


        }, { error ->
            Log.e("response:onFail", error.toString())
            try {
                iVolleyRequest.getResponse(null, error.message, RESULT_FAILED)
                iVolleyRequest.onFail(null)
            } catch (e: Exception) {
            }
        }) {
            override fun getParams(): Map<String, String> {
                return map
            }
        }

        stringRequest.retryPolicy = DefaultRetryPolicy(
                MY_VOLLEY_TIME_OUT,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT)

        MyApp.getInstance().addToRequestQueue(stringRequest)
    }

    companion object {

        private const val MY_VOLLEY_TIME_OUT = 0
        private var volleyRequest: VolleyRequest? = null

        const val RESULT_SUCCESS = 1
        const val RESULT_FAILED = 0

        fun getVolleyRequest(): VolleyRequest {
            @Synchronized
            if (volleyRequest == null)
                volleyRequest = VolleyRequest()

            return volleyRequest as VolleyRequest
        }
    }

}
