//
//  DriversViewController.swift
//  We1lAdmin
//
//  Created by omar altayyan on 11/1/18.
//  Copyright © 2018 juger. All rights reserved.
//


import Autotech


class DriversViewController: ATEntityListVC
{
    var driverID: Int? = nil
    
    override func getOperationKey() -> String
    {
        return "Drivers"
    }
    
    override func getCellReuseIdentifier() -> String
    {
        return "driversCell"
    }
    
    override func dataRequestEndPointPostfix() -> String {
        return driversURLPostfix
    }
    
    override func getSegueID() -> String
    {
        return "goToInvoices"
    }
    
    override func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        let selectedData = self.dataToView![indexPath.item] as! NSDictionary
        
        self.driverID = selectedData["ID"] as? Int
        
        super.tableView(tableView, didSelectRowAt: indexPath)
    }
    
    override func prepare(for segue: UIStoryboardSegue, sender: Any?) {
        if segue.identifier == getSegueID()
        {
            let destination = segue.destination as! InvoicesViewController
            destination.driverId = driverID
            
        }
        super.prepare(for: segue, sender: sender)
    }
    
}
