//
//  EmployeeDetailsViewController.swift
//  We1lAdmin
//
//  Created by omar altayyan on 10/31/18.
//  Copyright © 2018 juger. All rights reserved.
//

import Autotech


class EmployeeDetailsViewController: ATEntityViewVC
{
    @IBOutlet weak var mobileLabel: UILabel!

    @IBOutlet weak var addressLabel: UILabel!

    @IBOutlet weak var emailLabel: UILabel!
    
    @IBOutlet weak var nationalityLabel: UILabel!
    
    @IBOutlet weak var positionLabel: UILabel!
    
    @IBOutlet weak var salaryLabel: UILabel!

    override open func useGlobalImageBackground() -> Bool
    {
        return true
    }
    
    override func fillFromDictionary(_ dataDictionary: NSDictionary) {
        
        self.mobileLabel.text = getJsonDictionaryStringValue(dataDictionary, "Mobile")
        self.addressLabel.text = getJsonDictionaryStringValue(dataDictionary, "Address")
        self.emailLabel.text = getJsonDictionaryStringValue(dataDictionary, "Email")
        self.nationalityLabel.text = getJsonDictionaryStringValue(dataDictionary, "Nationality")
        self.positionLabel.text = getJsonDictionaryStringValue(dataDictionary, "Position")
        self.salaryLabel.text = getJsonDictionaryStringValue(dataDictionary, "Salary")
        
        self.title = getJsonDictionaryStringValue(dataDictionary, "FullName")

    }
    
}
