//
//  InvoiceDetailsViewController.swift
//  We1lAdmin
//
//  Created by omar altayyan on 11/1/18.
//  Copyright © 2018 juger. All rights reserved.
//
import Autotech
import GoogleMaps

class InvoiceDetailsViewController: ATEntityListVC
{
  
    let MAPVIEW_CELL_IDENTIFIER = "mapViewTableCell"
    
    let TEXT_FIELDS_CELL_IDENTIFIER = "textContentTableCell"
    
    let MAPVIEW_CELL_HEIGHT: CGFloat = 300
    
    let TEXT_FIELDS_CELL_HEIGHT: CGFloat = 600

    var mainDataDictionary: NSDictionary? = nil
    
    
    
    override func viewDidLoad() {
        
        self.embeddingMode = .staticUnSegueableTableOnly
        
        super.viewDidLoad()
        
        if dataToView == nil
        {
            dataToView = []
        }
        
        // any empty objects for the map and text field cells
        dataToView = NSArray.init(array: ["", ""] + dataToView!)
        
        if mainDataDictionary != nil
        {
            let dataDict = mainDataDictionary!
            
            
            self.title = "Order: " + (dataDict["OrderNumber"] as! String)
            
            
        }
        
        
    }
    
    override func hasDataToLoad() -> Bool {
        return false
    }
    
    override func getCellReuseIdentifier() -> String
    {
        return "invoiceDetailsTableCell"
    }
    
    override func getSegueID() -> String
    {
        return ""
    }
    
//    override func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
//        return super.tableView(tableView, numberOfRowsInSection: section) + 2
//    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        if indexPath.item == 0
        {
            return TEXT_FIELDS_CELL_HEIGHT
        }
        else if indexPath.item == 1
        {
            return MAPVIEW_CELL_HEIGHT
        }
        return tableView.rowHeight
        

    }
//
//    fileprivate func getNewIndexPath(_ indexPath: IndexPath) -> IndexPath {
//        return IndexPath.init(row: indexPath.row - 2, section: indexPath.section)
//
//    }
    
    override func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        if indexPath.row == 0
        {
            let cell = tableView.dequeueReusableCell(withIdentifier: TEXT_FIELDS_CELL_IDENTIFIER, for: indexPath)as! ATEntityFillableTableCell

            cell.fillFromDictionary(mainDataDictionary!)
            return cell
        }
        else if indexPath.row == 1
        {
            let cell = tableView.dequeueReusableCell(withIdentifier: MAPVIEW_CELL_IDENTIFIER, for: indexPath)as! ATEntityFillableTableCell
            cell.fillFromDictionary(mainDataDictionary!)
            return cell
        }
        return super.tableView(tableView, cellForRowAt: indexPath)
        
    }
    
}
