//
//  InvoicesViewController.swift
//  We1lAdmin
//
//  Created by omar altayyan on 11/1/18.
//  Copyright © 2018 juger. All rights reserved.
//

import Autotech
import AFDateHelper

class InvoicesViewController: ATEntityListVC
{
    
    var driverId: Int? = nil
    
    @IBOutlet weak var fromDatePicker: UIDatePicker!
    
    @IBOutlet weak var toDatePicker: UIDatePicker!
    
    override func viewDidLoad() {
        
        super.viewDidLoad()

        let date = Date.init()
        
        fromDatePicker.maximumDate = date
        
        toDatePicker.maximumDate = date
        
        toDatePicker.setDate(date, animated: false)
        
        let components = Calendar.current.dateComponents([.year, .month], from: date)
        
        let startOfMonth =  Calendar.current.date(from: components)!
        
        fromDatePicker.setDate(startOfMonth, animated: false)
        
        toDatePicker.minimumDate = startOfMonth

        
        toDatePicker.setValue(UIColor.white, forKey: "textColor")
        
        fromDatePicker.setValue(UIColor.white, forKey: "textColor")

    }
    
    
    @IBAction func toDateChanged(_ sender: Any) {
        fromDatePicker.maximumDate = toDatePicker.date
        if toDatePicker.date < fromDatePicker.date
        {
            toDatePicker.setDate(fromDatePicker.date, animated: true)
            
        }
        self.reloadData()
    }
    
    @IBAction func fromDateChanged(_ sender: Any) {
        toDatePicker.minimumDate = fromDatePicker.date
        if fromDatePicker.date > toDatePicker.date
        {
            fromDatePicker.setDate(toDatePicker.date, animated: true)
        }
        self.reloadData()
    }
    
    override func getOperationKey() -> String
    {
        return "Invoices"
    }
    
    override func getCellReuseIdentifier() -> String
    {
        return "invoicesMainTableCell"
    }
    
    override func dataRequestEndPointPostfix() -> String
    {
        return invoicesURLPostfix
    }
    
    override func dataRequestPostDict() -> PostDict
    {
        let fromDate = fromDatePicker.date.adjust(hour: 0, minute: 0, second: 0)
        
        let toDate = toDatePicker.date.adjust(hour: 23, minute: 59, second: 59)
        
        let selectedFromDate = Int(fromDate.timeIntervalSince1970)
        
        let selectedToDate = Int(toDate.timeIntervalSince1970)
        
        
        var postDict = ["From": "\(selectedFromDate)",
            "To": "\(selectedToDate)"]
        
        if driverId != nil
        {
            postDict["Driver"] = "\(driverId!)"
        }
        
        NSLog("Post Dict: \(postDict)")
        
        return postDict
    }
    
    override func getSegueID() -> String {
        return "goToInvoiceDetails"
    }
    
    override func prepare(for segue: UIStoryboardSegue, sender: Any?) {
        if getSegueID() != "" && segue.identifier == self.getSegueID()
        {
            let index = sender as! Int
            let destination = segue.destination as! InvoiceDetailsViewController
            destination.mainDataDictionary = self.dataToView![index] as? NSDictionary
            destination.dataToView = destination.mainDataDictionary!["InvoiceDetails"] as? NSArray
            
        }
    }
    
}
