//
//  mapViewTableCell.swift
//  We1lAdmin
//
//  Created by omar altayyan on 11/5/18.
//  Copyright © 2018 juger. All rights reserved.
//


import Autotech
import GoogleMaps

class invoiceDetailsMapViewTableCell: ATEntityFillableTableCell {
    
    @IBOutlet weak var mapView: GMSMapView!

    
    
    override func fillFromDictionary(_ dataDict: NSDictionary)
    {
        
        let longtitudeString = getJsonDictionaryStringValue(dataDict, "Lon")
        
        let latatitudeString = getJsonDictionaryStringValue(dataDict, "Lat")
        
        if longtitudeString != "" && latatitudeString != ""
        {
            let longtitude = Double(longtitudeString)
            
            let latatitude = Double(latatitudeString)
            
            if (longtitude != nil && latatitude != nil)
            {
                let camera = GMSCameraPosition.camera(withLatitude: latatitude!, longitude: longtitude!, zoom: 12.0)
                self.mapView.camera = camera
                
                // Creates a marker in the center of the map.
                let marker = GMSMarker()
                marker.map = self.mapView
                marker.position = CLLocationCoordinate2D(latitude: latatitude!, longitude: longtitude!)
                marker.title = "Customer Shipped Location"
                let address = getJsonDictionaryStringValue(dataDict, "Address")
                marker.snippet = address == "" ? "Shipping Address" : address
                self.mapView.selectedMarker = marker
            }
        }
    }
    
    
}
