//
//  invoiceDetailsTableCell.swift
//  We1lAdmin
//
//  Created by omar altayyan on 11/4/18.
//  Copyright © 2018 juger. All rights reserved.
//


import Autotech

class invoiceDetailsTableCell: ATEntityFillableTableCell {
    
    
    @IBOutlet weak var productPriceLabel: UILabel!
    
    @IBOutlet weak var productCurrencyLabel: UILabel!
    
    @IBOutlet weak var productNameLabel: UILabel!
    
    @IBOutlet weak var productQuantityLabel: UILabel!
    
    
    override func fillFromDictionary(_ dataDict: NSDictionary)
    {
        
        self.productCurrencyLabel.text = "Currency: " + getJsonDictionaryStringValue(dataDict, "CurrencyName")
        self.productQuantityLabel.text = "Quantity: " + getJsonDictionaryStringValue(dataDict, "Quantity")

        let _productInfoDict = dataDict["Product"]
        
        if _productInfoDict != nil
        {
            let productInfoDict = _productInfoDict as! NSDictionary
            
            self.productPriceLabel.text = "Price: " + getJsonDictionaryStringValue(productInfoDict, "Price")
            self.productNameLabel.text = getJsonDictionaryStringValue(productInfoDict, "Name")

        }
        
        
        
    }
    
    
}
