//
//  invoiceDetailsTextFieldsTableCell.swift
//  We1lAdmin
//
//  Created by omar altayyan on 11/5/18.
//  Copyright © 2018 juger. All rights reserved.
//


import Autotech

class invoiceDetailsTextFieldsTableCell: ATEntityFillableTableCell {
    

    @IBOutlet weak var awbLabel: UILabel!
    
    @IBOutlet weak var dateLabel: UILabel!
    
    @IBOutlet weak var statusLabel: UILabel!
    
    
    @IBOutlet weak var totalQuantityLabel: UILabel!
    
    @IBOutlet weak var totalPriceLabel: UILabel!
    
    @IBOutlet weak var isFinishedLabel: UILabel!
    
    @IBOutlet weak var addressLabel: UILabel!
    
    @IBOutlet weak var promotionLabel: UILabel!
    
    @IBOutlet weak var regionLabel: UILabel!
    
    
    
    @IBOutlet weak var guestNameLabel: UILabel!
    
    @IBOutlet weak var guestPhoneLabel: UILabel!
    
    @IBOutlet weak var guestMobileLabel: UILabel!
    
    
    
    override func fillFromDictionary(_ dataDict: NSDictionary)
    {
        self.awbLabel.text = getJsonDictionaryStringValue(dataDict, "AWBNumber")
        self.statusLabel.text = getJsonDictionaryStringValue(dataDict, "Status")
        
        self.dateLabel.text = getJsonDictionaryDateValue(dataDict, "AddDateTime")
        
        
        self.isFinishedLabel.text = getJsonDictionaryBoolValue(dataDict, "IsFinished")
        
        self.addressLabel.text = getJsonDictionaryStringValue(dataDict, "Address")
        
        self.promotionLabel.text = getJsonDictionaryBoolValue(dataDict, "Promotion")
        
        self.regionLabel.text = getJsonDictionaryStringValue(dataDict, "Region")
        
        
        
        self.guestNameLabel.text = getJsonDictionaryStringValue(dataDict, "OutName")
        
        self.guestPhoneLabel.text = getJsonDictionaryStringValue(dataDict, "OutPhone")
        
        self.guestMobileLabel.text = getJsonDictionaryStringValue(dataDict, "OutMobile")
        
        
        self.totalQuantityLabel.text = String(getJsonDictionaryIntegerValue(dataDict, "TotalQTY"))
        
        self.totalPriceLabel.text = String(getJsonDictionaryIntegerValue(dataDict, "TotalPrice"))
        
        
        
    }
    
    
}
