//
//  MenuViewController.swift
//  We1lAdmin
//
//  Created by juger on 8/26/18.
//  Copyright © 2018 juger. All rights reserved.
//

import Autotech

struct NavigationCellInfo
{
    var imageName: String!
    var label: String!
    var segueKey: String!
}

class MenuViewController: ATBaseVC {

    
    //MARK:- Outlets
    @IBOutlet weak var tableView: UITableView!
    

    //    NavigationCellInfo(imageName: "cost", label: "Total Money of sales", segueKey: "goToTotalMoney"),
    
    //MARK:- Variables
    var navigationCellsInfo = [
        
        NavigationCellInfo(imageName: "Products", label: "Products", segueKey: "goToProductsPerStore"),
        NavigationCellInfo(imageName: "Invoice", label: "Invoices", segueKey: "goToInvoices"),
        NavigationCellInfo(imageName: "Salary", label: "Monthly Salaries", segueKey: "goToPerMonthSalaries"),
        NavigationCellInfo(imageName: "customer", label: "Customers", segueKey: "goToCustomers"),
        NavigationCellInfo(imageName: "Drivers", label: "Drivers", segueKey: "goToDrives"),
        NavigationCellInfo(imageName: "Employee", label: "Employees", segueKey: "goToEmployees"),
        NavigationCellInfo(imageName: "Supplier", label: "Supplier Orders", segueKey: "goToSupplierOrders"),
        NavigationCellInfo(imageName: "Statistics", label: "General Statistics", segueKey: "goToGeneralStatistics")
    
    ]
    
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        tableView.delegate = self
        tableView.dataSource = self
        tableView.register(UINib(nibName : "MenuTableViewCell" , bundle : nil), forCellReuseIdentifier: "menuCells")

    }

    
    override func getTableViews() -> Array<UITableView> {
        return [self.tableView]
    }

    @IBAction func logout(_ sender: Any) {
        self.performSegue(withIdentifier: LOGOUT_SEGUE_ID, sender: self)
    }
}

//MARK:- Extension For Table View
extension MenuViewController : UITableViewDataSource , UITableViewDelegate
{
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return navigationCellsInfo.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        
        let cell = tableView.dequeueReusableCell(withIdentifier:"menuCells", for: indexPath) as! MenuTableViewCell
        cell.imageOfItem.image = UIImage(named: navigationCellsInfo[indexPath.item].imageName)
        cell.nameOfItem.text = navigationCellsInfo[indexPath.item].label
        
        return cell
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        
        performSegue(withIdentifier: navigationCellsInfo[indexPath.item].segueKey, sender: self)
        
    }
    
    
}
