//
//  PublicStatisticsViewController.swift
//  We1lAdmin
//
//  Created by juger on 8/26/18.
//  Copyright © 2018 juger. All rights reserved.
//

import Autotech

class PublicStatisticsCell{
    var cellTitle: String
    var cellValue: Int
    
    var cellValueAnimated = false
    
    init(withCellTitle cellTitle: String, withCellValue cellValue: Int) {
        self.cellTitle = cellTitle.camelCaseToWords()
        self.cellValue = cellValue
    }
    
    static let supportedColors = [
        UIColor.init("CC6699"),
        UIColor.init("006699"),
        UIColor.init("0099CC"),
        UIColor.init("66CC33"),
        UIColor.init("333333"),
        ]
    
}

class PublicStatisticsViewController: ATBaseVC {
    @IBOutlet weak var collectionView: UICollectionView!
    
    let publicStatisticsOPKey = "public"
    
    override func hasDataToLoad() -> Bool
    {
        return true
    }
    override func reloadData() {
        var config = self.basicRequestConfig()
        
        config.serviceEndPoint = publicStatisticsURLPostfix
        config.context = publicStatisticsOPKey
        
        
        ATAPICommunicator.shared.createTask(config)
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()

        collectionView.delegate = self
        collectionView.dataSource = self
        collectionView.register(UINib(nibName : "NumberSalesCollectionViewCell" , bundle : nil), forCellWithReuseIdentifier: "numberSalesCells")
        
    }

    
    override func getCollectionViews() -> Array<UICollectionView> {
        return [self.collectionView]
    }
    
    var publicStatisticsData: Array<PublicStatisticsCell> = []
    
    
    
    override func requestSuccess(withLoadedData data: NSDictionary, withContext context: String?) {
        super.requestSuccess(withLoadedData: data, withContext: context)
        if context != nil && context == publicStatisticsOPKey
        {
            publicStatisticsData = []
            let data = data[ATSettings.API.innerDataField] as! NSDictionary
            
            for (_key, _value) in data {
                let key = _key as! String
                let value = _value as! Int
                publicStatisticsData.append(PublicStatisticsCell(withCellTitle: key, withCellValue: value))
            }
            
            collectionView.reloadData()
        }
    }
    

}

//MARK:- Extension For Collection View
extension PublicStatisticsViewController : UICollectionViewDataSource , UICollectionViewDelegate , UICollectionViewDelegateFlowLayout
{
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        return publicStatisticsData.count
    }
    
    
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "numberSalesCells", for: indexPath) as! NumberSalesCollectionViewCell
        
        cell.numberSalesBackground.backgroundColor = PublicStatisticsCell.supportedColors[indexPath.item % PublicStatisticsCell.supportedColors.count]
        
        cell.numberOfSales.text = String(self.publicStatisticsData[indexPath.item].cellValue)
        
        cell.nameOfProduct.text = self.publicStatisticsData[indexPath.item].cellTitle
        
        return cell
    }
    
    func collectionView(_ collectionView: UICollectionView, willDisplay cell: UICollectionViewCell, forItemAt indexPath: IndexPath) {
        
        let statisticsCell = self.publicStatisticsData[indexPath.item]
        
        
        if !statisticsCell.cellValueAnimated
        {
            statisticsCell.cellValueAnimated = true
            
            let cell = cell as! NumberSalesCollectionViewCell
            
            if let text = cell.numberOfSales.text, let valueAsInt = Int(text)
            {
                cell.numberOfSales.countFromZero(to: CGFloat(valueAsInt))
            }
        }
        
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
        let size = CGSize.init(width: (self.view.frame.width / 2.3 ), height: self.view.frame.width / 3 )
        
        return size
        
    }
    
    
}
