//
//  ForgotPasswordViewController.swift
//  We1lAdmin
//
//  Created by omar altayyan on 10/28/18.
//  Copyright © 2018 juger. All rights reserved.
//

import UIKit

import Autotech

import SkyFloatingLabelTextField


class ForgotPasswordViewController: ATEntityFormVC {
    
    var initialEmail = ""
    
    @IBOutlet weak var emailTextField: SkyFloatingLabelTextField!
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        self.emailTextField.text = initialEmail
    }
    
    override func operationEndPointURLPostfix(operationKey: String) -> String {
        return forgotPasswordURLPostfix
    }
    
    override func awakeFromNib() {
        super.awakeFromNib()
        self.modifyButtonTitles = false
    }

    @IBAction func DoneClicked(_ sender: Any) {
        dismissThisVC()
    }
    
    override func validateInput() throws
    {
        try ATValidation.validateEmailField(emailTextField, mandatory: true, fieldName: nil)
    }
    
    
    override func mainActionOperationKey() -> String {
        return "forgotPassword"
    }
    override func operationSuccessMessage(operationKey: String) -> String {
        return "An Email was sent to your inbox if the email was correct"
    }
    
    override func operationPostDict(operationKey: String) -> PostDict {
        return ["Email": "\(self.emailTextField.text!)"]
    }
    
}
