//
//  ViewController.swift
//  We1lAdmin
//
//  Created by juger on 8/26/18.
//  Copyright © 2018 juger. All rights reserved.
//

import UIKit
import Autotech
import SkyFloatingLabelTextField

class SignInViewController: ATEntityFormVC {
    
    
    let logoutOPContextKey = "logout"
    
    let loginOPContextKey = "login"
    
    //MARK:- Outlets
    @IBOutlet weak var emailTextField: SkyFloatingLabelTextField!
    @IBOutlet weak var passwordTextField: SkyFloatingLabelTextField!
    
    override func awakeFromNib() {
        super.awakeFromNib()
        self.modifyButtonTitles = false
    }
    
    override func sendRequestOfOperation(operationKey: String, httpMethod: String) {
        NSLog("Perform Sign In called")
        
        ATAPICommunicator.shared.sendSignInRequest(loginURLPostfix, withUsername: self.emailTextField.text, andPassword: self.passwordTextField!.text, withContext: loginOPContextKey)
    }
    
    
    
    override func prepare(for segue: UIStoryboardSegue, sender: Any?) {
        if segue.identifier == "goToForgotPassword" || segue.identifier == "goToCreateAccount"
        {
            let forgotPasswordVC = segue.destination as! ForgotPasswordViewController
            
            forgotPasswordVC.initialEmail = self.emailTextField.text!
        }
        
    }
    
    var accountID : Int = -1
    
    
    override func validateInput() throws
    {
        try ATValidation.validateEmailField(emailTextField, mandatory: true, fieldName: nil)
        try ATValidation.validateFieldExists(passwordTextField, trimBeforeChecking: false, fieldName: nil)
    }
    
    
    @IBAction func unwindToMe(segue: UIStoryboardSegue){
        
        if self.accountID >= 0
        {
            var config = self.basicRequestConfig()
            
            config.serviceEndPoint = logoutURLPostfix
            config.postDict = ["Account": "\(self.accountID)"]
            config.context = logoutOPContextKey
            
            ATAPICommunicator.shared.createTask(config)

        }
        
        ATAPICommunicator.shared.clearLoginInfo()
        
        self.passwordTextField?.text = ""
    }
    
    
    override func canPerformUnwindSegueAction(_ action: Selector, from fromViewController: UIViewController, withSender sender: Any) -> Bool {
        return true
    }
    
    //MARK:- API Communication Protocol
    override func sessionInvalid(withContext context: String?) {
        super.sessionInvalid(withContext: context)
        self.passwordTextField?.text = ""
    }
    
    
    override func requestSuccess(withLoadedData data: NSDictionary, withContext context: String?) {
        super.requestSuccess(withLoadedData: data, withContext: context)
        if context != nil && context! == logoutOPContextKey
        {
            NSLog("logout success")
        }
        
        if context != nil && context! == loginOPContextKey
        {
            NSLog(data.description)
            
            
            let innerData = data["Data"] as! NSDictionary
            self.accountID = innerData["ID"] as! Int
            
            performSegue(withIdentifier: "goToMainMenu", sender: self)
            
        }
        
        
    }
}
