//
//  AnalyzeViewController.swift
//  E-CommerceDirector
//
//  Created by juger on 8/27/18.
//  Copyright © 2018 juger. All rights reserved.
//

import UIKit
import Charts

class AnalyzeViewController: DemoBaseViewController {

    
    //MARK:- Outlets
    @IBOutlet weak var barChartView: BarChartView!
    //MARK:- Variables
    
    var days: [String]!
    
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        settingsChart()
    }
    
    
    func settingsChart()
    {
        
        self.title = "Horizontal Bar Char"
        self.options = [.toggleValues,
                        .toggleIcons,
                        .toggleHighlight,
                        .animateX,
                        .animateY,
                        .animateXY,
                        .saveToGallery,
                        .togglePinchZoom,
                        .toggleAutoScaleMinMax,
                        .toggleData,
                        .toggleBarBorders]
        
        self.setup(barLineChartView: barChartView)
        
        barChartView.delegate = self
        barChartView.drawBarShadowEnabled = false
        barChartView.drawValueAboveBarEnabled = true
        
        
        //if there is no data into the chart
        barChartView.noDataText = "there is no data"
        days = ["Satday","Sunday","Mday" , "Tday", "Wday","Thday","Fday"]
        let tasks = [1.0,2.5,3.5,4.5,5.5,6.5,7.5]
        
        barChartView.rightAxis.enabled = false
        barChartView.xAxis.labelPosition = .bottom
        barChartView.xAxis.valueFormatter = self
        barChartView.xAxis.axisLineWidth = 1.0
        barChartView.xAxis.labelWidth = 1.0
        barChartView.xAxis.axisMinimum = 0
        barChartView.xAxis.drawAxisLineEnabled = true
        barChartView.xAxis.granularity = 1
        
        
        
        let leftAxis = barChartView.leftAxis
        leftAxis.labelFont = .systemFont(ofSize: 10)
        leftAxis.drawAxisLineEnabled = true
        leftAxis.drawGridLinesEnabled = true
        leftAxis.axisMinimum = 0
        leftAxis.axisMaximum = 3000.0
        
        let leftAxisFormatter = NumberFormatter()
        leftAxisFormatter.minimumFractionDigits = 0
        leftAxisFormatter.maximumFractionDigits = 1
        leftAxisFormatter.negativeSuffix = " $"
        leftAxisFormatter.positiveSuffix = " $"
        leftAxis.valueFormatter = DefaultAxisValueFormatter(formatter: leftAxisFormatter)
        
        
        
        
        
        let l = barChartView.legend
        l.horizontalAlignment = .left
        l.verticalAlignment = .bottom
        l.orientation = .horizontal
        l.drawInside = false
        l.form = .square
        l.formSize = 8
        l.font = UIFont(name: "HelveticaNeue-Light", size: 11)!
        l.xEntrySpace = 4
        
        
        barChartView.fitBars = true
        
        setChart(dataPoints: days, values: tasks)
    }
    
    func setChart(dataPoints: [String] , values: [Double])
    {
        var dataEntries: [BarChartDataEntry] = []
        var counter = 0.0
        
        for i in 0..<dataPoints.count {
            counter += 200.0
            let dataEntry = BarChartDataEntry(x: values[i], y: counter)
            dataEntries.append(dataEntry)
        }
        
        let chartDataSet = BarChartDataSet(values: dataEntries, label: "Time")
        
        chartDataSet.stackLabels = days
        
        let chartData = BarChartData(dataSet: chartDataSet)
        barChartView.data = chartData
        
        
        chartData.barWidth = 0.5
        
//        let colors = [UIColor.black,UIColor.gray,UIColor.green,UIColor.blue,UIColor.orange,UIColor.yellow,UIColor.darkGray]
        
        
         chartDataSet.colors = ChartColorTemplates.colorful() //to take a default colors
        
       // chartDataSet.colors = colors
        
        
        
        barChartView.animate(xAxisDuration: 2.0, yAxisDuration: 2.0)
        
    }
    
    
    

}

extension AnalyzeViewController: IAxisValueFormatter {
    func stringForValue(_ value: Double, axis: AxisBase?) -> String {
        return days[Int(value) % days.count]
    }
}

