//
//  TotalMoneyViewController.swift
//  E-CommerceDirector
//
//  Created by juger on 8/27/18.
//  Copyright © 2018 juger. All rights reserved.
//

import UIKit
import Charts

class TotalMoneyViewController: ParentViewController {

    //MARK:- Outlets
    @IBOutlet weak var pieChart: PieChartView!
    @IBOutlet weak var tableView: UITableView!
    
    //MARK:- Variables
    //Data Value of our charts
    var iosDataEntry = PieChartDataEntry(value: 25)
    var macDataEntry = PieChartDataEntry(value: 50)
    var winDataEntry = PieChartDataEntry(value: 25)
    var numberOfDownloadDataEntries = [PieChartDataEntry]()
    
    
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        tableView.dataSource = self
        tableView.delegate = self
        tableView.register(UINib(nibName: "TotalMoneyTableViewCell" , bundle : nil), forCellReuseIdentifier: "totalMoneyCells")
        
        

        //Pie chart configuretion
        pieChart.chartDescription?.text = ""
        
//        iosDataEntry.value = 25
//        macDataEntry.value = 75
        
        //Add lable to the chart
        iosDataEntry.label = "Eyebrow"
        macDataEntry.label = "Lipstick"
        winDataEntry.label = "Brush"
        
        numberOfDownloadDataEntries = [iosDataEntry , macDataEntry , winDataEntry]
        
        pieChart.holeRadiusPercent = 0.60
        
        updateChartData()
        
    }
    
    func updateChartData() {
        //fisrt make a data set for chart
        let chartDataSet = PieChartDataSet(values: numberOfDownloadDataEntries, label: nil)
        //create data object
        let chartData = PieChartData(dataSet: chartDataSet)
        
        //Add some color to the chart
        let colors = [UIColor.init("7FBCFF"), UIColor.init("DCBBED"), UIColor.init("B2E1F7")]
        
        //ASSign colors to our chart
        chartDataSet.colors = colors
        
        
        ///use the assign data to PieChart
        pieChart.data = chartData
        
        
        
    }

    override func getTableViews() -> Array<UITableView> {
        return [self.tableView]
    }


}

extension TotalMoneyViewController : UITableViewDataSource , UITableViewDelegate {
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return 50
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "totalMoneyCells", for: indexPath) as! TotalMoneyTableViewCell
        return cell
    }
    
    
}



