//
//  AppDelegate.swift
//  E-commerce
//
//  Created by juger on 8/2/18.
//  Copyright © 2018 juger. All rights reserved.
//

import UIKit
import SideMenu
import IQKeyboardManagerSwift
import DropDown



var isLandscape : Bool = false
let systemPasscode : String = "PYxqb@vb"
var userId :  Int?
var userLoggedIn : Bool = false
@UIApplicationMain
class AppDelegate: UIResponder, UIApplicationDelegate {

    var window: UIWindow?
    /// set orientations you want to be allowed in this property by default
    var orientationLock = UIInterfaceOrientationMask.all
    
    var arr = [CategoryObj]()

    func application(_ application: UIApplication, didFinishLaunchingWithOptions launchOptions: [UIApplication.LaunchOptionsKey: Any]?) -> Bool {
        
        NotificationCenter.default.addObserver(self, selector: #selector(AppDelegate.rotated), name: UIDevice.orientationDidChangeNotification, object: nil)
        
        
        UINavigationBar.appearance().tintColor = UIColor.init("333333")

        
        IQKeyboardManager.shared.enable = true
        
//        self.show()
//        Communication.shared.f_WS_101 { (res) in
//            self.hide()
//            self.arr = res
//            self.tab.reload()
//        }
        
        DropDown.startListeningToKeyboard()
        
       userLoggedIn =  setup()
        
        return true
    }
    
    
    func setup() -> Bool {
        let loggedIn = UserDefaults.standard.bool(forKey: "isLoggedIn")
        if loggedIn {
            let storyBoard = UIStoryboard(name: "Main", bundle: nil)
//            let vc = storyBoard.instantiateViewController(withIdentifier: "HomeStoryboard") as! HomeViewController
            let vc = storyBoard.instantiateViewController(withIdentifier: "HomeVC") as! HomeVC

            let navigationCont = UINavigationController(rootViewController: vc)
            userId = UserDefaults.standard.integer(forKey: "userID")
            self.window?.rootViewController = navigationCont
            return true
        }
        
        return false
    }

    func applicationWillResignActive(_ application: UIApplication) {
        // Sent when the application is about to move from active to inactive state. This can occur for certain types of temporary interruptions (such as an incoming phone call or SMS message) or when the user quits the application and it begins the transition to the background state.
        // Use this method to pause ongoing tasks, disable timers, and invalidate graphics rendering callbacks. Games should use this method to pause the game.
    }

    func applicationDidEnterBackground(_ application: UIApplication) {
        // Use this method to release shared resources, save user data, invalidate timers, and store enough application state information to restore your application to its current state in case it is terminated later.
        // If your application supports background execution, this method is called instead of applicationWillTerminate: when the user quits.
    }

    func applicationWillEnterForeground(_ application: UIApplication) {
        // Called as part of the transition from the background to the active state; here you can undo many of the changes made on entering the background.
    }

    func applicationDidBecomeActive(_ application: UIApplication) {
        // Restart any tasks that were paused (or not yet started) while the application was inactive. If the application was previously in the background, optionally refresh the user interface.
    }

    func applicationWillTerminate(_ application: UIApplication) {
        // Called when the application is about to terminate. Save data if appropriate. See also applicationDidEnterBackground:.
    }
    
    @objc func rotated() {
        switch UIDevice.current.orientation {
        case .landscapeLeft, .landscapeRight:
            print("Landscape")
            SideMenuManager.default.menuLeftNavigationController?.dismiss(animated: true, completion: nil)
            SideMenuManager.default.menuWidth = UIScreen.main.bounds.width * 2 / 3
            isLandscape = true
        case .portrait, .portraitUpsideDown:
//            print("Portrait")
            SideMenuManager.default.menuLeftNavigationController?.dismiss(animated: true, completion: nil)
            SideMenuManager.default.menuWidth = UIScreen.main.bounds.width * 2 / 3
            isLandscape = false
        default:
            print("other")
        }
    }
    
    func application(_ application: UIApplication, supportedInterfaceOrientationsFor window: UIWindow?) -> UIInterfaceOrientationMask {
        return self.orientationLock
    }



}

