//
//  CategoryObj.swift
//  E-commerce
//
//  Created by Yahya Tabba on 9/22/18.
//  Copyright © 2018 juger. All rights reserved.
//

import Foundation
import ObjectMapper
import SwiftyJSON



class CategoryObj : BaseEntity{
    
    var ID : JSON!
    var Name : String!
    var MobileImageURL : String!
    var WebImageURL : String!
    var IsRectangle : JSON!
    var Child = [Int]()
    var Products = [Product]()
    var categories = [CategoryObj]()


    
    required convenience public init?(map: Map) {
        self.init()
    }
    
    override func mapping(map: Map) {
        super.mapping(map: map)
        
        ID <- map["ID"]
        Name <- map["Name"]
        MobileImageURL <- map["MobileImageURL"]
        WebImageURL <- map["WebImageURL"]
        IsRectangle <- map["IsRectangle"]
        Child <- map["Child"]
        Products <- map["Products"]
        categories <- map["categories"]
    }
    
    
    
    
    static func loadNeasted(_ res : [CategoryObj] , i : Int) -> [CategoryObj]{
        var catsBases = [CategoryObj]()
        
        if i == 0{
            for c in res{
                if res.filter({$0.Child.contains(c.ID.intValue)}).isEmpty{
                    catsBases.append(c)
                }
            }
        }else{
            if let id = res.first(where: {$0.ID.intValue == i}){
                catsBases = res.filter({id.Child.contains($0.ID.intValue)})
            }
        }
        
        for j in catsBases{
            j.categories += loadNeasted(res,i : j.ID.intValue)
        }
        
        return catsBases
    }

}



