//
//  Order.swift
//  E-commerce
//
//  Created by Yahya Tabba on 10/27/18.
//  Copyright © 2018 juger. All rights reserved.
//

import Foundation
import ObjectMapper
import SwiftyJSON

class Order : BaseEntity{
    
    var ID : JSON!
    var OrderNumber : String!
    var AWBNumber : String!
    var AddDateTime : JSON!
    var Status : String!
    var CurrencyOnSale : JSON!
    var Address : String!
    var IsFinished : JSON!
    var PublicPromotionID : String!
    var PrivatePromotionID : String!
    var Lat : JSON!
    var Lon : JSON!
    var RegionID : String!
    var CustomerRate : JSON!
    var OutName : JSON!
    var OutPhone : JSON!
    var OutMobile : JSON!
    var InvoiceDetails : [InvoiceDetailsObj]!
    
    
    required convenience public init?(map: Map) {
        self.init()
    }
    
    override func mapping(map: Map) {
        super.mapping(map: map)
        
        ID <- map["ID"]
        OrderNumber <- map["OrderNumber"]
        AWBNumber <- map["AWBNumber"]
        AddDateTime <- map["AddDateTime"]
        Status <- map["Status"]
        CurrencyOnSale <- map["CurrencyOnSale"]
        Address <- map["Address"]
        IsFinished <- map["IsFinished"]
        PublicPromotionID <- map["PublicPromotionID"]
        PrivatePromotionID <- map["PrivatePromotionID"]
        Lat <- map["Lat"]
        Lon <- map["Lon"]
        RegionID <- map["RegionID"]
        CustomerRate <- map["CustomerRate"]
        OutName <- map["OutName"]
        OutPhone <- map["OutPhone"]
        OutMobile <- map["OutMobile"]
        InvoiceDetails <- map["InvoiceDetails"]
    }
}



