//
//  Product.swift
//  E-commerce
//
//  Created by Yahya Tabba on 10/27/18.
//  Copyright © 2018 juger. All rights reserved.
//

import Foundation
import ObjectMapper
import SwiftyJSON

class Product : BaseEntity{
    
    var ID : JSON!
    var CategoryID : JSON!
    var BrandID : JSON!
    var Name : String!
    var Content : String!
    var Price : JSON!
    var PriceBeforeSale : JSON!
    var SKU : String!
    var AddDateTime : JSON!
    var ReturnPolicyDays : JSON!
    var ReturnPolicyText : String!
    var ExpDate : JSON!
    var IsPharma : JSON!
    var IsOffer : JSON!
    var IsNew : JSON!
    var IsAcceptPromotion : JSON!
    var IsWished : JSON!
    
    var Images : ImagesObj!
    
    required convenience public init?(map: Map) {
        self.init()
    }
    
    override func mapping(map: Map) {
        super.mapping(map: map)
        
        ID <- map["ID"]
        CategoryID <- map["CategoryID"]
        BrandID <- map["BrandID"]
        Name <- map["Name"]
        Content <- map["Content"]
        Price <- map["Price"]
        PriceBeforeSale <- map["PriceBeforeSale"]
        SKU <- map["SKU"]
        AddDateTime <- map["AddDateTime"]
        ReturnPolicyDays <- map["ReturnPolicyDays"]
        ReturnPolicyText <- map["ReturnPolicyText"]
        ExpDate <- map["ExpDate"]
        IsPharma <- map["IsPharma"]
        IsOffer <- map["IsOffer"]
        IsNew <- map["IsNew"]
        IsAcceptPromotion <- map["IsAcceptPromotion"]
        IsWished <- map["IsWished"]
        Images <- map["Images"]
    }
    
}





