//
//  Communication.swift
//  Prodygie
//
//  Created by Yahya Tabba on 4/21/18.
//  Copyright © 2018 Autotech co. All rights reserved.
//

import Foundation
import Alamofire
import AlamofireObjectMapper
import SwiftyJSON
import ObjectMapper

typealias ServiceResponse = (JSON?, NSError?) -> Void

class Communication: BaseManager {
    
    static let shared = Communication()
    
    let encodingQuery = URLEncoding(destination: .queryString)
    let encodingBody = URLEncoding(destination: .httpBody)
    let baseParams : [String : Any] = ["SystemPasscode" : systemPasscode]
    
    
    func login(callback : @escaping ([Order]) -> Void){
        let url = URL(string: "\(BASEURL)\(loginURL)")!
        
        var params = self.baseParams
        params["Customer"] = User.getID()
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    var res = [Order]()
                    
                    for i in value.Data["Data"].arrayValue{
                        let a = Order(JSON: i.dictionaryObject!)!
                        res.append(a)
                    }
                    
                    callback(res)
                }
                    
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
                
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
                break
            }
        }
    }

    func changePassword(OldPassword : String,NewPassword : String, callback : @escaping (Bool) -> Void){
        let url = URL(string: "\(BASEURL)\(changePasswordURL)")!
        
        var params = self.baseParams
        params["Customer"] = User.getID()
        params["Email"] = User.getCurrentUser().Email
        params["OldPassword"] = OldPassword
        params["NewPassword"] = NewPassword
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    callback(value.Data["Status"].Boolean)
                }
                    
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
                
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
                break
            }
        }
    }

    
    
    func categories(callback : @escaping ([CategoryObj]) -> Void){
        let url = URL(string: "\(BASEURL)\(categoriesURL)")!
        
        var params = self.baseParams
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    var res = [CategoryObj]()
                    
                    for i in value.Data["Data"].arrayValue{
                        let a = CategoryObj(JSON: i.dictionaryObject!)!
                        res.append(a)
                    }
                    
                    callback(res)
                }
                    
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
                
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
                break
            }
        }
    }
    
    func category(ID : String, callback : @escaping (CategoryObj) -> Void){
        let url = URL(string: "\(BASEURL)\(categoryURL)")!
        
        var params = self.baseParams
        params["ID"] = ID
        params["Customer"] = User.getID()

        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    if let i = value.Data["Data"].dictionaryObject{
                        if let a = CategoryObj(JSON: i){
                            callback(a)
                        }
                    }
                }
                    
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
                
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
                break
            }
        }
    }


    
    func getOrders(callback : @escaping ([Order]) -> Void){
        let url = URL(string: "\(BASEURL)\(ordersURL)")!
        
        var params = self.baseParams
        params["Customer"] = User.getID()

        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    var res = [Order]()
                    
                    for i in value.Data["Data"].arrayValue{
                        let a = Order(JSON: i.dictionaryObject!)!
                        res.append(a)
                    }
                    
                    callback(res)
                }
                    
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
                
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
                break
            }
        }
    }
    
    func track(OrderNumber : String, AWBNumber : String, callback : @escaping ([TrackItem]) -> Void){
        let url = URL(string: "\(BASEURL)\(trackURL)")!
        
        var params = self.baseParams
        params["OrderNumber"] = OrderNumber
        params["AWBNumber"] = OrderNumber
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    var res = [TrackItem]()
                    
                    for i in value.Data["Data"].arrayValue{
                        let a = TrackItem(JSON: i.dictionaryObject!)!
                        res.append(a)
                    }
                    
                    callback(res)
                }
                    
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
                
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
                break
            }
        }
    }

    
    func product(ID : String,callback : @escaping (Product,JSON?) -> Void){
        let url = URL(string: "\(BASEURL)\(productURL)")!
        
        var params = self.baseParams
        params["ID"] = ID
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    if let i = value.Data["Data"].dictionaryObject{
                        if let a = Product(JSON: i){
                            callback(a,response.value?.Data)
                        }
                    }
                }
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
                
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
                break
            }
        }
    }
    
    
    
    func place(callback : @escaping ([Place]) -> Void){
        let url = URL(string: "\(BASEURL)\(placeURL)")!
        
        var params = self.baseParams
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    var res = [Place]()
                    
                    for i in value.Data["Data"].arrayValue{
                        let a = Place(JSON: i.dictionaryObject!)!
                        res.append(a)
                    }
                    
                    callback(res)
                }
                    
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
                
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
                break
            }
        }
    }



    func myWishList(callback : @escaping ([Product]) -> Void){
        let url = URL(string: "\(BASEURL)\(myWishURL)")!
        
        var params = self.baseParams
        params["Customer"] = User.getID()

        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    var res = [Product]()
                    
                    for i in value.Data["Data"].arrayValue{
                        let a = Product(JSON: i.dictionaryObject!)!
                        res.append(a)
                    }
                    
                    callback(res)
                }
                    
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
                
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
                break
            }
        }
    }

    func deleteWish(ProductID : String, callback : @escaping (Bool) -> Void){
        let url = URL(string: "\(BASEURL)\(deleteWishURL)")!
        
        var params = self.baseParams
        params["Product"] = ProductID
        params["Customer"] = User.getID()

        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    callback(value.Data["Status"].Boolean)
                }
                    
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
                
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
                break
            }
        }
    }
    
    func addWish(ProductID : String, callback : @escaping (Bool) -> Void){
        let url = URL(string: "\(BASEURL)\(addWishURL)")!
        
        var params = self.baseParams
        params["Product"] = ProductID
        params["Customer"] = User.getID()
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    callback(value.Data["Status"].Boolean)
                }
                    
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
                
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
                break
            }
        }
    }


    func promotion(callback : @escaping ([Promotion]) -> Void){
        let url = URL(string: "\(BASEURL)\(promotionURL)")!
        
        var params = self.baseParams
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    var res = [Promotion]()
                    
                    for i in value.Data["Data"].arrayValue{
                        let a = Promotion(JSON: i.dictionaryObject!)!
                        res.append(a)
                    }
                    
                    callback(res)
                }
                    
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
                
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
                break
            }
        }
    }
    
    func myPromotion(callback : @escaping ([Promotion]) -> Void){
        let url = URL(string: "\(BASEURL)\(myPromotionURL)")!
        
        var params = self.baseParams
        params["Customer"] = User.getID()
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    var res = [Promotion]()
                    
                    for i in value.Data["Data"].arrayValue{
                        let a = Promotion(JSON: i.dictionaryObject!)!
                        res.append(a)
                    }
                    
                    callback(res)
                }
                    
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
                
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
                break
            }
        }
    }


    func takePromotion(Promotion : String, callback : @escaping (Bool) -> Void){
        let url = URL(string: "\(BASEURL)\(takePromotionURL)")!
        
        var params = self.baseParams
        params["Customer"] = User.getID()
        params["Promotion"] = Promotion
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    callback(value.Data["Status"].Boolean)
                }
                    
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
                
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
                break
            }
        }
    }

    
    func currency(callback : @escaping ([Currency]) -> Void){
        let url = URL(string: "\(BASEURL)\(currencyURL)")!
        
        var params = self.baseParams
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    var res = [Currency]()
                    
                    for i in value.Data["Data"].arrayValue{
                        let a = Currency(JSON: i.dictionaryObject!)!
                        res.append(a)
                    }
                    
                    callback(res)
                }
                    
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
                
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
                break
            }
        }
    }
    
    func shippingCompany(callback : @escaping ([ShippingCompany]) -> Void){
        let url = URL(string: "\(BASEURL)\(shippingCompanyURL)")!
        
        var params = self.baseParams
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    var res = [ShippingCompany]()
                    
                    for i in value.Data["Data"].arrayValue{
                        let a = ShippingCompany(JSON: i.dictionaryObject!)!
                        res.append(a)
                    }
                    
                    callback(res)
                }
                    
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
                
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
                break
            }
        }
    }
    
    func myAddresses(callback : @escaping ([Address]) -> Void){
        let url = URL(string: "\(BASEURL)\(myAddressesURL)")!
        
        var params = self.baseParams
        params["Customer"] = User.getID()
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    var res = [Address]()
                    
                    for i in value.Data["Data"].arrayValue{
                        let a = Address(JSON: i.dictionaryObject!)!
                        res.append(a)
                    }
                    
                    callback(res)
                }
                    
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
                
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
                break
            }
        }
    }


    func brands(callback : @escaping ([Brand]) -> Void){
        let url = URL(string: "\(BASEURL)\(brandsURL)")!
        
        var params = self.baseParams
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    var res = [Brand]()
                    
                    for i in value.Data["Data"].arrayValue{
                        let a = Brand(JSON: i.dictionaryObject!)!
                        res.append(a)
                    }
                    
                    callback(res)
                }
                    
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
                
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
                break
            }
        }
    }


    func locationInfo(callback : @escaping (LocationInfo) -> Void){
        let url = URL(string: "\(BASEURL)\(locationInfoURL)")!
        
        var params = self.baseParams
        params["Customer"] = User.getID()
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    if let i = value.Data.dictionaryObject{
                        if let a = LocationInfo(JSON: i){
                            callback(a)
                        }
                    }
                }
                    
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
                
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
                break
            }
        }
    }

    
    func slider(callback : @escaping ([SliderItem]) -> Void){
        let url = URL(string: "\(BASEURL)\(sliderURL)")!
        
        var params = self.baseParams
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    var res = [SliderItem]()
                    
                    for i in value.Data["Data"].arrayValue{
                        let a = SliderItem(JSON: i.dictionaryObject!)!
                        res.append(a)
                    }
                    
                    callback(res)
                }
                    
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
                
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
                break
            }
        }
    }
    
    
    func homeProducts(callback : @escaping ([ProductHomeType]) -> Void){
        let url = URL(string: "\(BASEURL)\(homeProductsURL)")!
        
        var params = self.baseParams
        params["Customer"] = User.getID()

        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    var res = [ProductHomeType]()
                    
                    for i in value.Data["Data"].arrayValue{
                        let a = ProductHomeType(JSON: i.dictionaryObject!)!
                        res.append(a)
                    }
                    
                    callback(res)
                }
                    
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
                
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
                break
            }
        }
    }
    
    func elanat(callback : @escaping (Elanat) -> Void){
        let url = URL(string: "\(BASEURL)\(elanatURL)")!
        
        var params = self.baseParams
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    if let i = value.Data.dictionaryObject{
                        if let a = Elanat(JSON: i){
                            callback(a)
                        }
                    }
                    
                }
                    
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
                
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
                break
            }
        }
    }
    
    func takeElanRegistered(Elan : String,callback : @escaping (Bool) -> Void){
        let url = URL(string: "\(BASEURL)\(takeElanRegisteredURL)")!
        
        var params = self.baseParams
        params["Elan"] = Elan
        params["Customer"] = User.getID()
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
//                    if let i = value.Data["Data"].dictionaryObject{
//                        if let a = Elanat(JSON: i){
//                            callback(a)
//                        }
//                    }
                    
                    callback(true)
                    
                }
                    
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
                
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
                break
            }
        }
    }
    
    func takeElanUnRegistered(Elan : String,Name : String,Email : String,Tel : String, callback : @escaping (Bool) -> Void){
        let url = URL(string: "\(BASEURL)\(takeElanUnRegisteredURL)")!
        
        var params = self.baseParams
        params["Elan"] = Elan
        params["Name"] = Name
        params["Email"] = Email
        params["Tel"] = Tel

        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    //                    if let i = value.Data["Data"].dictionaryObject{
                    //                        if let a = Elanat(JSON: i){
                    //                            callback(a)
                    //                        }
                    //                    }
                    
                    callback(true)
                    
                }
                    
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
                
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
                break
            }
        }
    }
    
    
    func todayHotDeals(callback : @escaping ([Today]) -> Void){
        let url = URL(string: "\(BASEURL)\(todayHotDealsURL)")!
        
        var params = self.baseParams
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    var res = [Today]()
                    
                    for i in value.Data["Data"].arrayValue{
                        let a = Today(JSON: i.dictionaryObject!)!
                        res.append(a)
                    }
                    
                    callback(res)
                }
                    
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
                
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
                break
            }
        }
    }
    

    
    func search(Text : String,callback : @escaping ([Product]) -> Void){
        let url = URL(string: "\(BASEURL)\(searchURL)")!
        
        var params = self.baseParams
        params["Text"] = Text
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    var res = [Product]()
                    
                    for i in value.Data["Data"].arrayValue{
                        let a = Product(JSON: i.dictionaryObject!)!
                        res.append(a)
                    }
                    
                    callback(res)
                }
                    
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
                
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
                break
            }
        }
    }

    
    func getStoreCredit(CurrencyID : String ,callback : @escaping (String) -> Void){
        let url = URL(string: "\(BASEURL)\(getStoreCreditURL)")!
        
        var params = self.baseParams
        params["Currency"] = CurrencyID
        params["Customer"] = User.getID()

        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    callback(value.Data["Data"].stringValue)
                }
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
                
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
                break
            }
        }
    }
    
    func bill(Products : [String], QTYs : [Int],Currency : String,callback : @escaping (String) -> Void){
        let url = URL(string: "\(BASEURL)\(billURL)")!
        
        var params = self.baseParams
        if let arr = JSON(Products).rawString(){
            params["Products"] = arr
        }
        if let arr = JSON(QTYs).rawString(){
            params["QTYs"] = arr
        }
        params["Currency"] = Currency
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    callback(value.Data["Data"].stringValue)
                }
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
                
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
                break
            }
        }
    }
    
    func billRegistered(Products : [String], QTYs : [Int],Currency : String,Private : String! = nil, Public : String! = nil, Customer : String, callback : @escaping (String) -> Void){
        let url = URL(string: "\(BASEURL)\(billRegisteredURL)")!
        
        var params = self.baseParams

        if let arr = JSON(Products).rawString(){
            params["Products"] = arr
        }
        if let arr = JSON(QTYs).rawString(){
            params["QTYs"] = arr
        }

        params["Currency"] = Currency
        params["Customer"] = Customer
        
        if let pr = Private{
            params["Private"] = pr
        }
        if let pu = Private{
            params["Public"] = pu
        }

        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    callback(value.Data["Data"]["FinalBill"].stringValue)
                }
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
                
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
                break
            }
        }
    }
    
    func order(Address : String,
               Products : [String],
               QTYs : [Int],
               StoreCredit : String,
               ShippingCompany : String,
               Public : String! = nil,
               Private : String! = nil,
               Lat : Double! = nil,
               Lon : Double! = nil,
               Region : String,
               Currency : String,
               
               callback : @escaping (String) -> Void){
        let url = URL(string: "\(BASEURL)\(orderURL)")!
        
        
        
        var params = self.baseParams
        params["Address"] = Address
        params["Customer"] = User.getID()
        params["StoreCredit"] = StoreCredit
        params["ShippingCompany"] = ShippingCompany
        params["Region"] = Region
        params["Currency"] = Currency

        if let v = Public{
            params["Public"] = v
        }
        if let v = Private{
            params["Private"] = v
        }
        if let v = Lat{
            params["Lat"] = v
        }
        if let v = Lon{
            params["Lon"] = v
        }
        

        if let arr = JSON(Products).rawString(){
            params["Products"] = arr
        }
        if let arr = JSON(QTYs).rawString(){
            params["QTYs"] = arr
        }
        var colors = [String]()
        for _ in Products{
            colors.append("0")
        }
        if let arr = JSON(colors).rawString(){
            params["Colors"] = arr
        }

        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    callback(value.Data["Data"].stringValue)
                }
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
                
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
                break
            }
        }
    }

    
    
    func orderNotRegistered(Address : String,
               Products : [String],
               QTYs : [Int],
               StoreCredit : String,
               ShippingCompany : String,
               Lat : Double! = nil,
               Lon : Double! = nil,
               Region : String,
               Currency : String,
               
               callback : @escaping (String) -> Void){
        let url = URL(string: "\(BASEURL)\(orderNotRegisteredURL)")!
        
        
        
        var params = self.baseParams
        params["Address"] = Address
        params["Customer"] = User.getID()
        params["StoreCredit"] = StoreCredit
        params["ShippingCompany"] = ShippingCompany
        params["Region"] = Region
        params["Currency"] = Currency
        
        if let v = Lat{
            params["Lat"] = v
        }
        if let v = Lon{
            params["Lon"] = v
        }
        
        
        if let arr = JSON(Products).rawString(){
            params["Products"] = arr
        }
        if let arr = JSON(QTYs).rawString(){
            params["QTYs"] = arr
        }
        var colors = [String]()
        for _ in Products{
            colors.append("0")
        }
        if let arr = JSON(colors).rawString(){
            params["Colors"] = arr
        }
        
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    callback(value.Data["Data"].stringValue)
                }
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
                
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
                break
            }
        }
    }

    func contactUs(Name : String,Email : String,Message : String,callback : @escaping (String) -> Void){
        let url = URL(string: "\(BASEURL)\(contactUsURL)")!
        
        var params = self.baseParams
        params["Name"] = Name
        params["Email"] = Email
        params["Message"] = Message
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    callback(value.Data["Data"].stringValue)
                }
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
                
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
                break
            }
        }
    }
    
    
    
    func addElan(Title : String,
                 Content : String,
                 StartAt : String,
                 NumberOfDays : String,
                 Name : String,
                 Tel : String,
                 Mobile : String,
                 Email : String,
                 Type : String,
                 PixelSize : String,
                 ImageURL : String,

                 callback : @escaping (String) -> Void){
        
        let url = URL(string: "\(BASEURL)\(addElanURL)")!
        
        var params = self.baseParams
        params["Title"] = Title
        params["Content"] = Content
        params["StartAt"] = StartAt
        params["NumberOfDays"] = NumberOfDays
        params["Name"] = Name
        params["Tel"] = Tel
        params["Mobile"] = Mobile
        params["Email"] = Email
        params["Type"] = Type
        params["PixelSize"] = PixelSize
        params["ImageURL"] = ImageURL
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    callback(value.Data["Data"].stringValue)
                }
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
                
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
                break
            }
        }
    }



    
    func output(_ res : DataResponse<CustomResponse>){
        if let urlString = res.request?.url?.absoluteString{
            print(urlString)
        }
        
        if let bod = res.request?.httpBody, let body = NSString(data: bod, encoding: String.Encoding.utf8.rawValue){
            print(body)
        }
        
        if let h = res.request?.allHTTPHeaderFields{
            print(h)
        }
        
        if let s = NSString(data: res.data!, encoding: String.Encoding.utf8.rawValue){
            print(s)
        }
    }
    
    
    func getHearders() -> [String : String]{
        
        let headers :  [String : String] = [:]
        
//        if User.isRegistered() || User.getCurrentUser().statues_key == User.USER_STATUES.PENDING_PROFILE.rawValue{
//            let me = User.getCurrentUser()
//            if let username = me.phone, let password = me.server_key{
//                let plainString = "\(username):\(password)" as NSString
//                let plainData = plainString.data(using: String.Encoding.utf8.rawValue)
//                let base64String = plainData?.base64EncodedString(options: NSData.Base64EncodingOptions(rawValue: 0))
//                headers["Authorization"] = "Basic \(base64String!)"
//            }
//        }
        
        return headers
    }
    
    
    
}

