//
//  FileManag.swift
//  Prodygie
//
//  Created by Yahya Tabba on 6/3/18.
//  Copyright © 2018 Autotech co. All rights reserved.
//

import Foundation

class FileManag {
    
    func saveFile(url : String, callback : @escaping (Data) -> Void) {
        
        if let fileName = url.components(separatedBy: "/").last{
            
            if let dir = FileManager.default.urls(for: .documentDirectory, in: .userDomainMask).first {
                
                let path = dir.appendingPathComponent(fileName)
                
                if let _ = UserDefaults.standard.value(forKey: url) as? String{
                    print("Exist")
                    do {
                        print("View")
                        try callback(Data.init(contentsOf: path))
                    }catch let err {
                        print(err.localizedDescription)
                    }
                }else{
                    getDataFromUrl(url: URL(string: url)!) { (data, response, error)  in
                        guard let data = data, error == nil else { return }
                        
                        DispatchQueue.main.async() { () -> Void in
                            do {
                                try data.write(to: path, options: Data.WritingOptions.atomic)
                                try callback(Data.init(contentsOf: path))
                                UserDefaults.standard.setValue("", forKey: url)
                            }catch let err{
                                print(err.localizedDescription)
                            }
                        }}
                }
            }
        }
        
    }
    
    
    func removeFile(url : String){
        if let fileName = url.components(separatedBy: "/").last{
            
            if let dir = FileManager.default.urls(for: .documentDirectory, in: .userDomainMask).first {
                
                let path = dir.appendingPathComponent(fileName)
                
                do{
                    try Data().write(to: path, options: Data.WritingOptions.atomic)
                    UserDefaults.standard.removeObject(forKey: url)
                }catch let err {
                    print(err.localizedDescription)
                }
            }
        }
    }
    
    
    
    
}

func getDataFromUrl(url: URL, completion: @escaping (_ data: Data?, _  response: URLResponse?, _ error: Error?) -> Void) {
    URLSession.shared.dataTask(with: url) {
        (data, response, error) in
        completion(data, response, error)
        }.resume()
}
