//
//  Provider.swift
//  Prodygie
//
//  Created by Yahya Tabba on 4/21/18.
//  Copyright © 2018 Autotech co. All rights reserved.
//

import Foundation
import UIKit
import SDWebImage
import MapKit
import CoreLocation

class Provider : BaseManager {
    
    static let shared = Provider()
    var locationManager = CLLocationManager()
    static var currentLocation = LocationInfo()

    static var Cart = [CartItem]()
    
    static func isValidEmail(_ testStr:String) -> Bool {
        let emailRegEx = "[A-Z0-9a-z._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,64}"
        
        let emailTest = NSPredicate(format:"SELF MATCHES %@", emailRegEx)
        return emailTest.evaluate(with: testStr)
    }
    
    
    static func getEnglishNumber(_ NumberStr : String) -> String{
        let Formatter: NumberFormatter = NumberFormatter()
        Formatter.locale = Locale(identifier: "EN")
        
        if let final = Formatter.number(from: NumberStr), final != 0{
            return String(describing: final)
        }else{
            return NumberStr
        }
    }
    
    
    
    func startUpdatingLocation() {
        locationManager = CLLocationManager()
        locationManager.requestAlwaysAuthorization()
        
        DispatchQueue.main.async {
            self.locationManager.startUpdatingLocation()
        }
    }
    
    func stopUpdatingLocation() {
        self.locationManager.stopUpdatingLocation()
    }
    
    static func isLocationPermissionGranted() -> Bool
    {
//        if Provider.shared.locationManager.location != nil{
//            return true
//        }
        guard CLLocationManager.locationServicesEnabled() else { return false }

        return [.authorizedAlways, .authorizedWhenInUse].contains(CLLocationManager.authorizationStatus())
    }

    
    
    static func getAttribute(text : String, font : UIFont, color : UIColor) -> NSAttributedString{
        
        let p = NSMutableParagraphStyle()
        p.alignment = .center
        //        p.paragraphSpacingBefore = 30
        p.paragraphSpacing = 10
        
        let attributedString = NSAttributedString(string: text, attributes: [
            NSAttributedString.Key.font : font,
            NSAttributedString.Key.foregroundColor : color,
            NSAttributedString.Key.paragraphStyle : p
            ])
        return attributedString
    }
    
    static func sd_setImage(_ img : UIImageView, urlString : String!, placeholderImage : UIImage! = nil){
        
        if let u = urlString,
            let us = u.addingPercentEncoding(withAllowedCharacters: CharacterSet.urlPathAllowed),
            let url = URL.init(string: urlString){
            
            img.sd_setImage(with: url, placeholderImage: placeholderImage, options: .refreshCached, completed: nil)
            
            //            img.kf.setImage(with: url, placeholder: nil, options: nil, progressBlock: nil, completionHandler: nil)
            
        }else{
            img.image = placeholderImage
        }
    }
    
    
    
    
}

