//
//  ViewController.swift
//  E-commerce
//
//  Created by juger on 8/2/18.
//  Copyright © 2018 juger. All rights reserved.
//

import UIKit

struct AppUtility {

    static func lockOrientation(_ orientation: UIInterfaceOrientationMask) {

        if let delegate = UIApplication.shared.delegate as? AppDelegate {
            delegate.orientationLock = orientation
        }
    }

    /// OPTIONAL Added method to adjust lock and rotate to the desired orientation
    static func lockOrientation(_ orientation: UIInterfaceOrientationMask, andRotateTo rotateOrientation:UIInterfaceOrientation) {

        self.lockOrientation(orientation)

        UIDevice.current.setValue(rotateOrientation.rawValue, forKey: "orientation")
    }

}
class ViewController: BaseVC {

    
    //MARK: - Outlets
    @IBOutlet weak var signInButton: UIButton!
    @IBOutlet weak var signUpButton: UIButton!
    override func viewDidLoad() {
        super.viewDidLoad()
        setButtonsDesign()
// UIApplication.shared.isStatusBarHidden = true
//
//        let value = UIInterfaceOrientation.portrait.rawValue
//        UIDevice.current.setValue(value, forKey: "orientation")
        
        AppUtility.lockOrientation(.portrait, andRotateTo: .portrait)
        
        self.navigationController?.isNavigationBarHidden = true

    }
    
    //MARK: - Actions
    @IBAction func signInTapped(_ sender: UIButton) {
        AppUtility.lockOrientation(.all)
        performSegue(withIdentifier: "goToSignInSegue", sender: self)
    }
    
    @IBAction func skipTapped(_ sender: UIButton) {
         print("Skip Tapped")
         AppUtility.lockOrientation(.all)
         performSegue(withIdentifier: "goToHomeSegue", sender: self)
       
    }
    
    //MARK: -Functions
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        //AppUtility.lockOrientation(.portrait)
        // Or to rotate and lock
         AppUtility.lockOrientation(.portrait, andRotateTo: .portrait)
    }

    override func viewWillDisappear(_ animated: Bool) {
        super.viewWillDisappear(animated)
        // Don't forget to reset when view is being removed
       AppUtility.lockOrientation(.all)
    }
      override var prefersStatusBarHidden: Bool
        {
        return true
        }
    
    func setButtonsDesign()
    {
        signInButton.backgroundColor = .clear
        signInButton.layer.cornerRadius = 25
        signInButton.layer.borderWidth = 2
        signInButton.layer.borderColor  = UIColor.white.cgColor
        
        signUpButton.layer.cornerRadius = 25
        signUpButton.layer.borderWidth = 2
        signUpButton.layer.borderColor  = UIColor.white.cgColor
    }


}

