//
//  CartCell.swift
//  E-commerce
//
//  Created by Yahya Tabba on 11/4/18.
//  Copyright © 2018 Autotech Co. All rights reserved.
//

import UIKit

class CartCell: UITableViewCell {
    
    @IBOutlet weak var nameLbl : UILabel!
    @IBOutlet weak var priceLbl : UILabel!
    @IBOutlet weak var qtyLbl : UILabel!
    @IBOutlet weak var img : UIImageView!

    var parentVC : CartVC?
    
    
    
    var cartItem : CartItem!{
        didSet{
            self.nameLbl.text = cartItem.Name
            self.priceLbl.text = cartItem.Price
            self.qtyLbl.text = "\(cartItem.QTY)"
            Provider.sd_setImage(img, urlString: cartItem.ImageURL)
        }
    }
    
    @IBAction func plusQTY(){
        Provider.Cart[self.tag].QTY += 1
        self.setQTY(Provider.Cart[self.tag].QTY)
    }
    
    @IBAction func minusQTY(){
        if Provider.Cart[self.tag].QTY == 1{
            self.delete()
        }else{
            Provider.Cart[self.tag].QTY -= 1
            self.setQTY(Provider.Cart[self.tag].QTY)
        }
    }
    
    @IBAction func delete(){
        self.parentVC?.tableView.beginUpdates()
        Provider.Cart.remove(at: self.tag)
        self.parentVC?.tableView.deleteRows(at: [IndexPath.init(row: self.tag, section: 0)], with: UITableView.RowAnimation.fade)
        self.parentVC?.tableView.endUpdates()
    }
    
    
    func setQTY(_ qty : Int){
        self.qtyLbl.text = "\(qty)"
        self.parentVC?.tableView.beginUpdates()
        self.parentVC?.tableView.reloadRows(at: [IndexPath.init(row: self.tag, section: 0)], with: UITableView.RowAnimation.fade)
        self.parentVC?.tableView.endUpdates()
    }
    
    
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }
    
    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)
        
        // Configure the view for the selected state
    }
    
}
